package com.estimote.scanning_plugin.packet_provider.service

import android.app.Service
import android.content.Intent
import android.os.Binder
import com.estimote.internal_plugins_api.scanning.EstimoteConnectivity
import com.estimote.internal_plugins_api.scanning.EstimoteRemoteLocation
import com.estimote.scanning_plugin.dagger.Dagger
import com.estimote.scanning_plugin.packet_provider.PacketProvider
import com.estimote.scanning_plugin.packet_provider.service.PacketProviderWrapperServiceHelper.LocalBinder
import com.estimote.scanning_plugin.settings.*
import com.wafel.skald.api.createLogger
import io.reactivex.Observable
import javax.inject.Inject

internal class PacketProviderWrapperService : Service(), PacketProvider {

    @Inject
    lateinit var serviceHelper: PacketProviderWrapperServiceHelper
    @Inject
    lateinit var packetProvider: PacketProvider
    private val binder = LocalBinder(this)
    private val logger = createLogger(this.javaClass)

    override fun onBind(intent: Intent): Binder {
        return binder
    }

    override fun onCreate() {
        super.onCreate()
        Dagger.create(applicationContext)
        Dagger.injectInTo(this)
    }

    override fun onStartCommand(intent: Intent?, flags: Int, startId: Int): Int {
        super.onStartCommand(intent, flags, startId)
        showNotification(intent)
        return START_NOT_STICKY
    }

    override fun onUnbind(intent: Intent?): Boolean {
        clearNotification()
        stopSelf()
        return true
    }

    override fun provideIBeacon(scanSettings: IBeaconScanSettings) =
            packetProvider.provideIBeacon(scanSettings)

    override fun provideEddystoneUid(scanSettings: EddystoneScanSettings) =
            packetProvider.provideEddystoneUid(scanSettings)

    override fun provideEstimoteLocation(scanSettings: EstimoteLocationScanSettings) =
            packetProvider.provideEstimoteLocation(scanSettings)

    override fun provideEstimoteMesh(scanSettings: EstimoteMeshScanSettings) =
            packetProvider.provideEstimoteMesh(scanSettings)

    override fun provideConnectivity(scanSettings: ConnectivityScanSettings) =
            packetProvider.provideConnectivity(scanSettings)

    override fun provideNearable(scanSettings: NearableScanSettings) =
            packetProvider.provideNearable(scanSettings)

    override fun provideEstimoteUwb(scanSettings: UwbScanSettings) =
            packetProvider.provideEstimoteUwb(scanSettings)

    override fun provideEstimoteMirror(scanSettings: MirrorScanSettings) =
            packetProvider.provideEstimoteMirror(scanSettings)

    override fun provideEstimoteTelemetryFrameA(scanSettings: EstimoteTelemetryScanSettings) =
            packetProvider.provideEstimoteTelemetryFrameA(scanSettings)

    override fun provideEstimoteTelemetryFrameB(scanSettings: EstimoteTelemetryScanSettings) =
            packetProvider.provideEstimoteTelemetryFrameB(scanSettings)

    override fun provideEstimoteTelemetryFull(scanSettings: EstimoteTelemetryScanSettings) =
            packetProvider.provideEstimoteTelemetryFull(scanSettings)

    override fun provideEstimoteSecure(scanSettings: EstimoteSecureScanSettings) =
            packetProvider.provideEstimoteSecure(scanSettings)

    override fun provideEstimoteRescue(scanSettings: EstimoteRescueScanSettings) =
            packetProvider.provideEstimoteRescue(scanSettings)

    override fun provideEstimoteLte(scanSettings: LteBeaconScanSettings) =
            packetProvider.provideEstimoteLte(scanSettings)

    override fun provideEstimoteRemoteLocation(scanSettings: RemoteLocationScanSettings) =
            packetProvider.provideEstimoteRemoteLocation(scanSettings)

    private fun showNotification(intent: Intent?) {
        serviceHelper.extractNotification(intent)?.apply {
            logger.debug("Starting foreground service.")
            startForeground(1, this)
        } ?: logger.debug("Received intent with null notification. No effect applied.")
    }

    private fun clearNotification() {
        if (android.os.Build.VERSION.SDK_INT >= 24) stopForeground(Service.STOP_FOREGROUND_REMOVE)
    }

}
