package com.estimote.scanning_plugin.packet_provider.scanner.filter_transformers

import android.annotation.TargetApi
import android.bluetooth.le.ScanFilter
import android.os.Build
import com.estimote.scanning_plugin.settings.EstimoteLocationScanSettings
import com.estimote.scanning_plugin.settings.RemoteLocationScanSettings

@TargetApi(Build.VERSION_CODES.LOLLIPOP)
internal class ToRemoteLocationFilterTransformer(private val filterBuilderFactory: HardwareFilterBuilderFactory, private val servicesUuidConfig: ServicesUuidConfig): DefaultScanFiltersTransformer.ScanFilterTransformer<RemoteLocationScanSettings> {
    private val REMOTE_LOCATION_TYPE_DATA = byteArrayOf(0x90.toByte())
    private val REMOTE_LOCATION_FRAME_MASK = byteArrayOf(0xFF.toByte())

    override fun transform(settings: RemoteLocationScanSettings): List<ScanFilter> {
        return listOf(filterBuilderFactory.newBuilder()
                .setServiceData(servicesUuidConfig.estimoteUUID, REMOTE_LOCATION_TYPE_DATA, REMOTE_LOCATION_FRAME_MASK)
                .build())
    }
}