package com.estimote.scanning_plugin.packet_provider.parsers

import android.annotation.TargetApi
import android.os.Build
import android.os.ParcelUuid
import com.estimote.scanning_plugin.packet_provider.EstimoteMacAddress
import com.estimote.scanning_plugin.packet_provider.EstimoteSecurePacket
import com.estimote.scanning_plugin.packet_provider.scanner.EstimoteScanResult
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteScanResultParser
import java.nio.ByteBuffer
import java.util.*

/**
 * @author Estimote Inc. (contact@estimote.com)
 */
@TargetApi(Build.VERSION_CODES.LOLLIPOP)
internal class EstimoteSecureParser: EstimoteScanResultParser<EstimoteSecurePacket> {

    private val ESTIMOTE_SERVICE_UUID = ParcelUuid(UUID.fromString("0000fe9a-0000-1000-8000-00805f9b34fb"))

    override fun parse(result: EstimoteScanResult): EstimoteSecurePacket {
        val bytes = ByteBuffer.wrap(result.scanRecord.getServiceData(ESTIMOTE_SERVICE_UUID))
        with(bytes) {
            return EstimoteSecurePacket(
                    EstimoteMacAddress(result.device.address),
                    result.rssi,
                    result.timestampNanosSinceBoot,
                    this.array()
            )
        }
    }
}