/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.scanning_plugin.packet_provider.parsers;

import android.annotation.TargetApi;
import android.os.ParcelUuid;
import com.estimote.android_ketchup.kotlin_goodness.HexStringsExtensionsKt;
import com.estimote.internal_plugins_api.scanning.EstimoteRemoteLocation;
import com.estimote.scanning_plugin.packet_provider.EstimoteMacAddress;
import com.estimote.scanning_plugin.packet_provider.EstimoteRemoteLocationPacket;
import com.estimote.scanning_plugin.packet_provider.scanner.EstimoteScanResult;
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteScanResultParser;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0002J\u0014\u0010\f\u001a\u00020\r*\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u000bH\u0002J\u0012\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u0013*\u00020\u000bH\u0002J\f\u0010\u0014\u001a\u00020\u000f*\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/estimote/scanning_plugin/packet_provider/parsers/EstimoteRemoteLocationParser;", "Lcom/estimote/scanning_plugin/packet_provider/use_cases/EstimoteScanResultParser;", "Lcom/estimote/scanning_plugin/packet_provider/EstimoteRemoteLocationPacket;", "()V", "ESTIMOTE_SERVICE_UUID", "Landroid/os/ParcelUuid;", "parse", "result", "Lcom/estimote/scanning_plugin/packet_provider/scanner/EstimoteScanResult;", "deviceId", "", "Ljava/nio/ByteBuffer;", "getHeardPacket", "Lcom/estimote/internal_plugins_api/scanning/EstimoteRemoteLocation$HeardPacket;", "startPosition", "", "heardIdentifier", "", "heardPackets", "", "heardRssi", "ParsedHeardPacket", "scanning-plugin_release"})
@TargetApi(value=21)
public final class EstimoteRemoteLocationParser
implements EstimoteScanResultParser<EstimoteRemoteLocationPacket> {
    private final ParcelUuid ESTIMOTE_SERVICE_UUID = new ParcelUuid(UUID.fromString("0000fe9a-0000-1000-8000-00805f9b34fb"));

    @Override
    @NotNull
    public EstimoteRemoteLocationPacket parse(@NotNull EstimoteScanResult result) {
        ByteBuffer bytes;
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        ByteBuffer $receiver = bytes = ByteBuffer.wrap(result.getScanRecord().getServiceData(this.ESTIMOTE_SERVICE_UUID));
        short s = this.deviceId($receiver);
        List<EstimoteRemoteLocation.HeardPacket> list = this.heardPackets($receiver);
        String string = result.getDevice().getAddress();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.device.address");
        return new EstimoteRemoteLocationPacket(s, list, new EstimoteMacAddress(string), result.getRssi(), result.getTimestampNanosSinceBoot());
    }

    private final short deviceId(@NotNull ByteBuffer $receiver) {
        $receiver.position(1);
        return $receiver.getShort();
    }

    private final List<EstimoteRemoteLocation.HeardPacket> heardPackets(@NotNull ByteBuffer $receiver) {
        int startPosition = 3;
        List packets = new ArrayList();
        while (startPosition + 5 <= $receiver.array().length) {
            Collection collection = packets;
            EstimoteRemoteLocation.HeardPacket heardPacket = this.getHeardPacket($receiver, startPosition);
            collection.add(heardPacket);
            startPosition += 5;
        }
        return packets;
    }

    private final EstimoteRemoteLocation.HeardPacket getHeardPacket(@NotNull ByteBuffer $receiver, int startPosition) {
        byte[] idBytes = new byte[4];
        $receiver.position(startPosition);
        $receiver.get(idBytes, 0, 4);
        return new ParsedHeardPacket(HexStringsExtensionsKt.toHexString((byte[])idBytes), -$receiver.get(startPosition + 4));
    }

    private final String heardIdentifier(@NotNull ByteBuffer $receiver) {
        byte[] idBytes = new byte[16];
        $receiver.position(1);
        $receiver.get(idBytes, 0, 16);
        return HexStringsExtensionsKt.toHexString((byte[])idBytes);
    }

    private final int heardRssi(@NotNull ByteBuffer $receiver) {
        return -$receiver.get(17);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/estimote/scanning_plugin/packet_provider/parsers/EstimoteRemoteLocationParser$ParsedHeardPacket;", "Lcom/estimote/internal_plugins_api/scanning/EstimoteRemoteLocation$HeardPacket;", "shortIdentifier", "", "rssi", "", "(Ljava/lang/String;I)V", "getRssi", "()I", "getShortIdentifier", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "scanning-plugin_release"})
    private static final class ParsedHeardPacket
    implements EstimoteRemoteLocation.HeardPacket {
        @NotNull
        private final String shortIdentifier;
        private final int rssi;

        @NotNull
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        public int getRssi() {
            return this.rssi;
        }

        public ParsedHeardPacket(@NotNull String shortIdentifier, int rssi) {
            Intrinsics.checkParameterIsNotNull((Object)shortIdentifier, (String)"shortIdentifier");
            this.shortIdentifier = shortIdentifier;
            this.rssi = rssi;
        }

        @NotNull
        public final String component1() {
            return this.getShortIdentifier();
        }

        public final int component2() {
            return this.getRssi();
        }

        @NotNull
        public final ParsedHeardPacket copy(@NotNull String shortIdentifier, int rssi) {
            Intrinsics.checkParameterIsNotNull((Object)shortIdentifier, (String)"shortIdentifier");
            return new ParsedHeardPacket(shortIdentifier, rssi);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ParsedHeardPacket copy$default(ParsedHeardPacket parsedHeardPacket, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = parsedHeardPacket.getShortIdentifier();
            }
            if ((n2 & 2) != 0) {
                n = parsedHeardPacket.getRssi();
            }
            return parsedHeardPacket.copy(string, n);
        }

        public String toString() {
            return "ParsedHeardPacket(shortIdentifier=" + this.getShortIdentifier() + ", rssi=" + this.getRssi() + ")";
        }

        public int hashCode() {
            String string = this.getShortIdentifier();
            return (string != null ? string.hashCode() : 0) * 31 + this.getRssi();
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ParsedHeardPacket)) break block3;
                    ParsedHeardPacket parsedHeardPacket = (ParsedHeardPacket)object;
                    if (!Intrinsics.areEqual((Object)this.getShortIdentifier(), (Object)parsedHeardPacket.getShortIdentifier()) || !(this.getRssi() == parsedHeardPacket.getRssi())) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

