package com.estimote.scanning_plugin.packet_provider.scanner.filter_transformers

import android.annotation.TargetApi
import android.bluetooth.le.ScanFilter
import android.os.Build
import com.estimote.scanning_plugin.settings.LteBeaconScanSettings

/**
 * @author Estimote Inc. (contact@estimote.com)
 */
@TargetApi(Build.VERSION_CODES.LOLLIPOP)
internal class ToLteBeaconFilterTransformer(private val filterBuilderFactory: HardwareFilterBuilderFactory,
                                            private val servicesUuidConfig: ServicesUuidConfig) : DefaultScanFiltersTransformer.ScanFilterTransformer<LteBeaconScanSettings> {

    override fun transform(settings: LteBeaconScanSettings): List<ScanFilter> {
        return listOf(
                filterBuilderFactory.newBuilder().setServiceUuid(servicesUuidConfig.estimoteUUID).build(),
                filterBuilderFactory.newBuilder().setServiceUuid(servicesUuidConfig.proximityUUID).build())
    }
}