/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.scanning_plugin.packet_provider.use_cases;

import android.annotation.TargetApi;
import com.estimote.scanning_plugin.packet_provider.EstimoteLteBeaconPacket;
import com.estimote.scanning_plugin.packet_provider.rssi_smoothers.RssiSmoother;
import com.estimote.scanning_plugin.packet_provider.scanner.EstimoteScanResult;
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteScanResultParser;
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteScanResultRecognizer;
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteScanner;
import com.estimote.scanning_plugin.packet_provider.use_cases.ExpirationCache;
import com.estimote.scanning_plugin.settings.LteBeaconScanSettings;
import io.reactivex.Observable;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\f\u0010\u0012\u001a\u00020\b*\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/estimote/scanning_plugin/packet_provider/use_cases/EstimoteLteScanUseCase;", "", "estimoteScanner", "Lcom/estimote/scanning_plugin/packet_provider/use_cases/EstimoteScanner;", "recognizer", "Lcom/estimote/scanning_plugin/packet_provider/use_cases/EstimoteScanResultRecognizer;", "parser", "Lcom/estimote/scanning_plugin/packet_provider/use_cases/EstimoteScanResultParser;", "Lcom/estimote/scanning_plugin/packet_provider/EstimoteLteBeaconPacket;", "rssiSmootherCache", "Lcom/estimote/scanning_plugin/packet_provider/use_cases/ExpirationCache;", "", "Lcom/estimote/scanning_plugin/packet_provider/rssi_smoothers/RssiSmoother;", "(Lcom/estimote/scanning_plugin/packet_provider/use_cases/EstimoteScanner;Lcom/estimote/scanning_plugin/packet_provider/use_cases/EstimoteScanResultRecognizer;Lcom/estimote/scanning_plugin/packet_provider/use_cases/EstimoteScanResultParser;Lcom/estimote/scanning_plugin/packet_provider/use_cases/ExpirationCache;)V", "run", "Lio/reactivex/Observable;", "scanSettings", "Lcom/estimote/scanning_plugin/settings/LteBeaconScanSettings;", "smoothRssi", "scanning-plugin_release"})
public final class EstimoteLteScanUseCase {
    private final EstimoteScanner estimoteScanner;
    private final EstimoteScanResultRecognizer recognizer;
    private final EstimoteScanResultParser<EstimoteLteBeaconPacket> parser;
    private final ExpirationCache<String, RssiSmoother> rssiSmootherCache;

    @TargetApi(value=21)
    @NotNull
    public final Observable<EstimoteLteBeaconPacket> run(@NotNull LteBeaconScanSettings scanSettings) {
        Intrinsics.checkParameterIsNotNull((Object)scanSettings, (String)"scanSettings");
        Observable observable = this.estimoteScanner.scan(scanSettings).filter((Predicate)new Predicate<EstimoteScanResult>(this){
            final /* synthetic */ EstimoteLteScanUseCase this$0;

            public final boolean test(@NotNull EstimoteScanResult it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return EstimoteLteScanUseCase.access$getRecognizer$p(this.this$0).recognize(it);
            }
            {
                this.this$0 = estimoteLteScanUseCase;
            }
        }).map(new Function<T, R>(this){
            final /* synthetic */ EstimoteLteScanUseCase this$0;

            @NotNull
            public final EstimoteLteBeaconPacket apply(@NotNull EstimoteScanResult it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return (EstimoteLteBeaconPacket)EstimoteLteScanUseCase.access$getParser$p(this.this$0).parse(it);
            }
            {
                this.this$0 = estimoteLteScanUseCase;
            }
        }).map(new Function<T, R>(this){
            final /* synthetic */ EstimoteLteScanUseCase this$0;

            @NotNull
            public final EstimoteLteBeaconPacket apply(@NotNull EstimoteLteBeaconPacket it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return EstimoteLteScanUseCase.access$smoothRssi(this.this$0, it);
            }
            {
                this.this$0 = estimoteLteScanUseCase;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"estimoteScanner.scan(sca\u2026 .map { it.smoothRssi() }");
        return observable;
    }

    private final EstimoteLteBeaconPacket smoothRssi(@NotNull EstimoteLteBeaconPacket $receiver) {
        RssiSmoother smoother = this.rssiSmootherCache.get($receiver.getMacAddress().getAddress());
        double smoothedRssi = smoother.smooth($receiver.getRssi(), (double)$receiver.getTimestamp() / 1.0E9);
        return EstimoteLteBeaconPacket.copy$default($receiver, null, null, null, null, false, false, null, (int)smoothedRssi, 0L, 383, null);
    }

    public EstimoteLteScanUseCase(@NotNull EstimoteScanner estimoteScanner, @NotNull EstimoteScanResultRecognizer recognizer, @NotNull EstimoteScanResultParser<EstimoteLteBeaconPacket> parser, @NotNull ExpirationCache<? super String, RssiSmoother> rssiSmootherCache) {
        Intrinsics.checkParameterIsNotNull((Object)estimoteScanner, (String)"estimoteScanner");
        Intrinsics.checkParameterIsNotNull((Object)recognizer, (String)"recognizer");
        Intrinsics.checkParameterIsNotNull(parser, (String)"parser");
        Intrinsics.checkParameterIsNotNull(rssiSmootherCache, (String)"rssiSmootherCache");
        this.estimoteScanner = estimoteScanner;
        this.recognizer = recognizer;
        this.parser = parser;
        this.rssiSmootherCache = rssiSmootherCache;
    }

    @NotNull
    public static final /* synthetic */ EstimoteScanResultRecognizer access$getRecognizer$p(EstimoteLteScanUseCase $this) {
        return $this.recognizer;
    }

    @NotNull
    public static final /* synthetic */ EstimoteScanResultParser access$getParser$p(EstimoteLteScanUseCase $this) {
        return $this.parser;
    }

    @NotNull
    public static final /* synthetic */ EstimoteLteBeaconPacket access$smoothRssi(EstimoteLteScanUseCase $this, @NotNull EstimoteLteBeaconPacket $receiver) {
        return $this.smoothRssi($receiver);
    }
}

