package com.estimote.scanning_plugin.packet_provider.use_cases

import android.annotation.TargetApi
import android.os.Build
import com.estimote.scanning_plugin.packet_provider.EstimoteMeshPacket
import com.estimote.scanning_plugin.packet_provider.rssi_smoothers.RssiSmoother
import com.estimote.scanning_plugin.settings.EstimoteMeshScanSettings
import io.reactivex.Observable

internal class EstimoteMeshScanUseCase(private val estimoteScanner: EstimoteScanner,
                                       private val recognizer: EstimoteScanResultRecognizer,
                                       private val parser: EstimoteScanResultParser<EstimoteMeshPacket>,
                                       private val rssiSmootherCache: ExpirationCache<String, RssiSmoother>) {

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    fun run(scanSettings: EstimoteMeshScanSettings): Observable<EstimoteMeshPacket> {
        return estimoteScanner.scan(scanSettings)
                .filter { recognizer.recognize(it) }
                .map { parser.parse(it) }
                .map { it.smoothRssi() }
    }

    private fun EstimoteMeshPacket.smoothRssi(): EstimoteMeshPacket {
        val smoother = rssiSmootherCache.get(macAddress.address)
        val smoothedRssi = smoother.smooth(rssi, this.timestamp/ 1000000000.0)
        return this.copy(rssi = smoothedRssi.toInt())
    }
}