package com.estimote.scanning_plugin.dagger

import com.estimote.scanning_plugin.packet_provider.EstimotePacketProvider
import com.estimote.scanning_plugin.packet_provider.PacketProvider
import com.estimote.scanning_plugin.packet_provider.use_cases.*
import dagger.Module
import dagger.Provides

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
@Module
internal class PacketProviderModule {

    @Provides
    @EstimoteScanningSdkScope
    fun providesPacketProvider(iBeaconScanUseCase: IBeaconScanUseCase,
                               eddystoneUidScanUseCase: EddystoneUidScanUseCase,
                               estimoteLocationScanUseCase: EstimoteLocationScanUseCase,
                               estimoteMeshScanUseCase: EstimoteMeshScanUseCase,
                               estimoteConnectivityScanUseCase: EstimoteConnectivityScanUseCase,
                               estimoteNearableScanUseCase: EstimoteNearableScanUseCase,
                               estimoteUwbScanUseCase: EstimoteUwbScanUseCase,
                               estimoteMirrorScanUseCase: EstimoteMirrorScanUseCase,
                               estimoteTelemetryAV0ScanUseCase: EstimoteTelemetryAV0ScanUseCase,
                               estimoteTelemetryAV1ScanUseCase: EstimoteTelemetryAV1ScanUseCase,
                               estimoteTelemetryAV2ScanUseCase: EstimoteTelemetryAV2ScanUseCase,
                               estimoteTelemetryBV0ScanUseCase: EstimoteTelemetryBV0ScanUseCase,
                               estimoteTelemetryBV1ScanUseCase: EstimoteTelemetryBV1ScanUseCase,
                               estimoteTelemetryBV2ScanUseCase: EstimoteTelemetryBV2ScanUseCase,
                               estimoteTelemetryFullScanUseCase: EstimoteTelemetryFullScanUseCase,
                               estimoteSecureScanUseCase: EstimoteSecureScanUseCase,
                               estimoteRescueScanUseCase: EstimoteRescueScanUseCase,
                               estimoteConnectivityIBeaconScanUseCase: EstimoteConnectivityIBeaconScanUseCase,
                               estimoteLteScanUseCase: EstimoteLteScanUseCase) : PacketProvider =

            EstimotePacketProvider(
                    iBeaconScanUseCase,
                    eddystoneUidScanUseCase,
                    estimoteLocationScanUseCase,
                    estimoteMeshScanUseCase,
                    estimoteConnectivityScanUseCase,
                    estimoteConnectivityIBeaconScanUseCase,
                    estimoteNearableScanUseCase,
                    estimoteUwbScanUseCase,
                    estimoteMirrorScanUseCase,
                    estimoteTelemetryAV0ScanUseCase,
                    estimoteTelemetryAV1ScanUseCase,
                    estimoteTelemetryAV2ScanUseCase,
                    estimoteTelemetryBV0ScanUseCase,
                    estimoteTelemetryBV1ScanUseCase,
                    estimoteTelemetryBV2ScanUseCase,
                    estimoteTelemetryFullScanUseCase,
                    estimoteSecureScanUseCase,
                    estimoteRescueScanUseCase,
                    estimoteLteScanUseCase)

}