package com.estimote.scanning_plugin.dagger

import android.bluetooth.BluetoothAdapter
import com.estimote.internal_plugins_api.scanning.BluetoothBackgroundTriggerConfigurator
import com.estimote.scanning_plugin.api.EstimoteBluetoothBackgroundTriggerConfigurator
import com.estimote.scanning_plugin.packet_provider.scanner.filter_transformers.*
import com.estimote.scanning_plugin.packet_provider.scanner.settings_transformers.ScanSettingsTransformerProvider
import dagger.Module
import dagger.Provides

@Module
internal class BluetoothTriggerModule {

    @Provides
    @EstimoteScanningSdkScope
    fun providesBluetoothTriggerConfigurator(
            adapter: BluetoothAdapter?,
            scanSettingsTransformerProvider: ScanSettingsTransformerProvider,
            servicesUuidConfig: ServicesUuidConfig): BluetoothBackgroundTriggerConfigurator =
            EstimoteBluetoothBackgroundTriggerConfigurator(
                    adapter,
                    scanSettingsTransformerProvider.getTransformer(),
                    DefaultScanFiltersTransformer(
                            ToIBeaconFilterTransformer(HardwareFilterBuilderFactory()),
                            ToEddystoneFilterTransformer(HardwareFilterBuilderFactory(), servicesUuidConfig),
                            ToEstimoteTelemetryFilterTransformer(HardwareFilterBuilderFactory(), servicesUuidConfig),
                            ToEstimoteLocationFilterTransformer(HardwareFilterBuilderFactory(), servicesUuidConfig),
                            ToEstimoteMeshFilterTransformer(HardwareFilterBuilderFactory(), servicesUuidConfig),
                            ToMirrorFilterTransformer(HardwareFilterBuilderFactory(), servicesUuidConfig),
                            ToUwbFilterTransformer(HardwareFilterBuilderFactory(), servicesUuidConfig),
                            ToNearableFilterTransformer(HardwareFilterBuilderFactory(), servicesUuidConfig),
                            ToConfigurableDeviceFilterTransformer(HardwareFilterBuilderFactory(), servicesUuidConfig),
                            ToEstimoteSecureFilterTransformers(HardwareFilterBuilderFactory(), servicesUuidConfig),
                            ToEstimoteRescueFilterTransformer(HardwareFilterBuilderFactory(), servicesUuidConfig),
                            ToLteBeaconFilterTransformer(HardwareFilterBuilderFactory(), servicesUuidConfig)))
}