/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.scanning_plugin.packet_provider.scanner.settings_transformers;

import android.annotation.TargetApi;
import android.bluetooth.le.ScanSettings;
import com.estimote.scanning_plugin.packet_provider.scanner.settings_transformers.DefaultScanSettingsTransformer;
import com.estimote.scanning_plugin.packet_provider.scanner.settings_transformers.ScanSettingsTransformerProvider;
import com.estimote.scanning_plugin.settings.EstimoteScanSettings;
import com.estimote.scanning_plugin.settings.ScanSettingsVisitor;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000b0\nH\u0003J\u001a\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u001a\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000b0\nH\u0003J\u001a\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000b0\nH\u0003J\u001a\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000b0\nH\u0003J\f\u0010\u0015\u001a\u00020\u0007*\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/estimote/scanning_plugin/packet_provider/scanner/settings_transformers/ScanSettingsTransformerProvider;", "", "androidApiVersion", "", "manufacturerId", "", "isOffloadedScanBatchingSupported", "", "(ILjava/lang/String;Z)V", "defaultPowerModeTransformer", "Lkotlin/Function2;", "Landroid/bluetooth/le/ScanSettings$Builder;", "Lcom/estimote/scanning_plugin/settings/EstimoteScanSettings$ScanPowerMode;", "getManufacturerSpecificTransformer", "getTransformer", "Lcom/estimote/scanning_plugin/settings/ScanSettingsVisitor;", "Landroid/bluetooth/le/ScanSettings;", "lollipopCallbackModeTransformer", "Lcom/estimote/scanning_plugin/settings/EstimoteScanSettings$ScanCallbackMode;", "marshmallowCallbackModeTransformer", "samsungPowerModeTransformer", "isSamsungDevice", "scanning-plugin_release"})
public final class ScanSettingsTransformerProvider {
    private final int androidApiVersion;
    private final String manufacturerId;
    private final boolean isOffloadedScanBatchingSupported;

    @NotNull
    public final ScanSettingsVisitor<ScanSettings> getTransformer() {
        Function2<ScanSettings.Builder, EstimoteScanSettings.ScanPowerMode, ScanSettings.Builder> powerModeTransformer = this.isOffloadedScanBatchingSupported ? this.getManufacturerSpecificTransformer() : this.defaultPowerModeTransformer();
        Function2<ScanSettings.Builder, EstimoteScanSettings.ScanCallbackMode, ScanSettings.Builder> callbackModeTransformer = this.androidApiVersion >= 23 ? this.marshmallowCallbackModeTransformer() : this.lollipopCallbackModeTransformer();
        return new DefaultScanSettingsTransformer(powerModeTransformer, callbackModeTransformer);
    }

    private final Function2<ScanSettings.Builder, EstimoteScanSettings.ScanPowerMode, ScanSettings.Builder> getManufacturerSpecificTransformer() {
        return this.isSamsungDevice(this.manufacturerId) ? this.samsungPowerModeTransformer() : this.defaultPowerModeTransformer();
    }

    private final boolean isSamsungDevice(@NotNull String $receiver) {
        return StringsKt.equals((String)$receiver, (String)"samsung", (boolean)true);
    }

    @TargetApi(value=21)
    private final Function2<ScanSettings.Builder, EstimoteScanSettings.ScanPowerMode, ScanSettings.Builder> defaultPowerModeTransformer() {
        return defaultPowerModeTransformer.1.INSTANCE;
    }

    @TargetApi(value=21)
    private final Function2<ScanSettings.Builder, EstimoteScanSettings.ScanPowerMode, ScanSettings.Builder> samsungPowerModeTransformer() {
        return samsungPowerModeTransformer.1.INSTANCE;
    }

    @TargetApi(value=23)
    private final Function2<ScanSettings.Builder, EstimoteScanSettings.ScanCallbackMode, ScanSettings.Builder> marshmallowCallbackModeTransformer() {
        return marshmallowCallbackModeTransformer.1.INSTANCE;
    }

    @TargetApi(value=21)
    private final Function2<ScanSettings.Builder, EstimoteScanSettings.ScanCallbackMode, ScanSettings.Builder> lollipopCallbackModeTransformer() {
        return lollipopCallbackModeTransformer.1.INSTANCE;
    }

    public ScanSettingsTransformerProvider(int androidApiVersion, @NotNull String manufacturerId, boolean isOffloadedScanBatchingSupported) {
        Intrinsics.checkParameterIsNotNull((Object)manufacturerId, (String)"manufacturerId");
        this.androidApiVersion = androidApiVersion;
        this.manufacturerId = manufacturerId;
        this.isOffloadedScanBatchingSupported = isOffloadedScanBatchingSupported;
    }
}

