/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.scanning_plugin.packet_provider.parsers;

import android.annotation.TargetApi;
import android.os.ParcelUuid;
import com.estimote.internal_plugins_api.scanning.MacAddress;
import com.estimote.scanning_plugin.packet_provider.EstimoteMacAddress;
import com.estimote.scanning_plugin.packet_provider.EstimoteSecurePacket;
import com.estimote.scanning_plugin.packet_provider.scanner.EstimoteScanResult;
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteScanResultParser;
import java.nio.ByteBuffer;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/estimote/scanning_plugin/packet_provider/parsers/EstimoteSecureParser;", "Lcom/estimote/scanning_plugin/packet_provider/use_cases/EstimoteScanResultParser;", "Lcom/estimote/scanning_plugin/packet_provider/EstimoteSecurePacket;", "()V", "ESTIMOTE_SERVICE_UUID", "Landroid/os/ParcelUuid;", "parse", "result", "Lcom/estimote/scanning_plugin/packet_provider/scanner/EstimoteScanResult;", "scanning-plugin_release"})
@TargetApi(value=21)
public final class EstimoteSecureParser
implements EstimoteScanResultParser<EstimoteSecurePacket> {
    private final ParcelUuid ESTIMOTE_SERVICE_UUID = new ParcelUuid(UUID.fromString("0000fe9a-0000-1000-8000-00805f9b34fb"));

    @Override
    @NotNull
    public EstimoteSecurePacket parse(@NotNull EstimoteScanResult result) {
        ByteBuffer bytes;
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        ByteBuffer $receiver = bytes = ByteBuffer.wrap(result.getScanRecord().getServiceData(this.ESTIMOTE_SERVICE_UUID));
        String string = result.getDevice().getAddress();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.device.address");
        MacAddress macAddress = new EstimoteMacAddress(string);
        int n = result.getRssi();
        long l = result.getTimestampNanosSinceBoot();
        byte[] byArray = $receiver.array();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"this.array()");
        return new EstimoteSecurePacket(macAddress, n, l, byArray);
    }
}

