package com.estimote.scanning_plugin.packet_provider.recognizers

import android.annotation.TargetApi
import android.bluetooth.le.ScanRecord
import android.os.Build
import com.estimote.scanning_plugin.packet_provider.scanner.EstimoteScanResult
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteScanResultRecognizer

/**
 * Legacy connectivity protocol for D3.4 beacons based on iBeacon
 * @author Estimote Inc. (contact@estimote.com)
 */
internal class EstimoteConnectivityIBeaconRecognizer : EstimoteScanResultRecognizer {

    private val APPLE_MANUFACTURER_ID = 0x004C

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    override fun recognize(result: EstimoteScanResult): Boolean {
        val scanRecord = result.scanRecord

        return scanRecord.getManufacturerSpecificData(APPLE_MANUFACTURER_ID) != null
                && scanRecord.getManufacturerSpecificData(APPLE_MANUFACTURER_ID).isNotEmpty()
                && (with(scanRecord.deviceName) { equals("EST", ignoreCase = true) || equals("estimote", ignoreCase = true) })
                && scanRecord.isConnectivity()
    }

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    private fun ScanRecord.isConnectivity(): Boolean {
        return advertiseFlags and 2 == 2
    }


}