package com.estimote.scanning_plugin.packet_provider.recognizers

import android.annotation.TargetApi
import android.os.Build
import android.os.ParcelUuid
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteScanResultRecognizer
import com.estimote.scanning_plugin.packet_provider.scanner.EstimoteScanResult
import java.util.*

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
@TargetApi(Build.VERSION_CODES.LOLLIPOP)
internal class EddystoneUidRecognizer : EstimoteScanResultRecognizer {
    private val EDDYSTONE_SERVICE_UUID = ParcelUuid(UUID.fromString("0000feaa-0000-1000-8000-00805f9b34fb"))

    override fun recognize(result: EstimoteScanResult): Boolean {
        val scanRecord = result.scanRecord
        with(scanRecord) {
            return serviceUuids?.contains(EDDYSTONE_SERVICE_UUID) ?: false
                    && getServiceData(EDDYSTONE_SERVICE_UUID) != null
                    && getServiceData(EDDYSTONE_SERVICE_UUID).isNotEmpty()
        }

    }
}