package com.estimote.scanning_plugin.dagger

import android.bluetooth.le.ScanFilter
import com.estimote.scanning_plugin.packet_provider.antenna_bias.AntennaBiasCorrection
import com.estimote.scanning_plugin.packet_provider.antenna_bias.AntennaBiasCorrectionFactory
import com.estimote.scanning_plugin.packet_provider.scanner.EstimoteScannerFactory
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteScanner
import com.estimote.scanning_plugin.packet_provider.scanner.ScannerFactory
import com.estimote.scanning_plugin.packet_provider.scanner.BluetoothLeScannerProvider
import com.estimote.scanning_plugin.packet_provider.scanner.settings_transformers.ScanSettingsTransformerProvider
import com.estimote.scanning_plugin.settings.ScanSettingsVisitor
import dagger.Module
import dagger.Provides

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */

@Module
internal class ScannerModule(private val androidVersion: Int,
                             private val manufacturerId: String,
                             private val deviceModel: String) {


    @Provides
    @EstimoteScanningSdkScope
    fun provideScannerFactory(bluetoothLeScannerProvider: BluetoothLeScannerProvider,
                              scanSettingsTransformerProvider: ScanSettingsTransformerProvider,
                              scanFiltersTransformer: ScanSettingsVisitor<List<ScanFilter>>): ScannerFactory {
        return EstimoteScannerFactory(bluetoothLeScannerProvider, scanSettingsTransformerProvider, scanFiltersTransformer)
    }

    @Provides
    @EstimoteScanningSdkScope
    fun provideScanner(scannerFactory: ScannerFactory): EstimoteScanner = scannerFactory.create(androidVersion)

    @Provides
    @EstimoteScanningSdkScope
    fun provideAntennaBiasCorrectionFactory(): AntennaBiasCorrection =
            AntennaBiasCorrectionFactory().getAntennaBiasForDevice(manufacturerId, deviceModel)

}