package com.estimote.scanning_plugin.packet_provider.scanner.filter_transformers

import android.annotation.TargetApi
import android.bluetooth.le.ScanFilter
import android.os.Build
import com.estimote.scanning_plugin.settings.UwbScanSettings

@TargetApi(Build.VERSION_CODES.LOLLIPOP)
internal class ToUwbFilterTransformer (private val filterBuilderFactory: HardwareFilterBuilderFactory, private val servicesUuidConfig: ServicesUuidConfig): DefaultScanFiltersTransformer.ScanFilterTransformer<UwbScanSettings> {
    private val UWB_FRAME_TYPE_DATA = byteArrayOf(0x04)
    private val UWB_FRAME_TYPE_MASK = byteArrayOf(0x0F)

    override fun transform(settings: UwbScanSettings): List<ScanFilter> {
        return listOf(filterBuilderFactory.newBuilder()
                .setServiceData(servicesUuidConfig.estimoteUUID, UWB_FRAME_TYPE_DATA, UWB_FRAME_TYPE_MASK)
                .build())
    }
}