package com.estimote.scanning_plugin.packet_provider.scanner.filter_transformers

import android.annotation.TargetApi
import android.bluetooth.le.ScanFilter
import android.os.Build
import com.estimote.scanning_plugin.settings.ConnectivityScanSettings

@TargetApi(Build.VERSION_CODES.LOLLIPOP)
internal class ToConfigurableDeviceFilterTransformer(private val filterBuilderFactory: HardwareFilterBuilderFactory, private val servicesUuidConfig: ServicesUuidConfig) : DefaultScanFiltersTransformer.ScanFilterTransformer<ConnectivityScanSettings> {

    private val APPLE_MANUFACTURER_ID = 0x004C
    private val APPLE_PREAMBLE = byteArrayOf(0x02, 0x015)

    override fun transform(settings: ConnectivityScanSettings): List<ScanFilter> {
        return listOf(
                filterBuilderFactory.newBuilder().setManufacturerData(APPLE_MANUFACTURER_ID, APPLE_PREAMBLE).build(),
                filterBuilderFactory.newBuilder().setServiceUuid(servicesUuidConfig.estimoteUUID).build(),
                filterBuilderFactory.newBuilder().setServiceUuid(servicesUuidConfig.proximityUUID).build(),
                filterBuilderFactory.newBuilder().setServiceUuid(servicesUuidConfig.eddystoneUUID).build())
    }
}