package com.estimote.scanning_plugin.dagger

import android.app.Notification
import android.content.Context
import com.estimote.scanning_plugin.packet_provider.service.PacketProviderWrapperServiceHelper
import dagger.Module
import dagger.Provides

/**
 * @author Estimote Inc. (contact@estimote.com)
 */
@Module
internal class NotificationModule(private val notification: Notification) {

    @NotificationScope
    @Provides
    fun providesNotification() = notification

    @Provides
    @NotificationScope
    fun providePacketProviderServiceWrapperStarter(context: Context, notification: Notification) =
            PacketProviderWrapperServiceHelper(context, notification)
}