package com.estimote.scanning_plugin.api.scan_launchers

import android.app.PendingIntent
import com.estimote.internal_plugins_api.scanning.BluetoothBackgroundTriggerConfigurator.TriggerScanLauncher
import com.estimote.internal_plugins_api.scanning.ScanHandler
import com.estimote.scanning_plugin.api.use_cases.TriggerUseCase
import com.estimote.scanning_plugin.settings.EstimoteScanSettings


internal abstract class BaseTriggerScanLauncher<SETTINGS_TYPE : EstimoteScanSettings, PACKET_TYPE, LAUNCHER : BaseTriggerScanLauncher<SETTINGS_TYPE, PACKET_TYPE, LAUNCHER>>(
        private val useCase: TriggerUseCase<SETTINGS_TYPE>) : TriggerScanLauncher<PACKET_TYPE> {

    internal var powerMode = EstimoteScanSettings.ScanPowerMode.BALANCED
    internal var callbackMode = EstimoteScanSettings.ScanCallbackMode.ALL_MATCH
    private var pendingIntent: PendingIntent? = null

    override fun trigger(intent: PendingIntent) = this.apply { this.pendingIntent = intent }
    override fun withOnlyOnFirstPacket(): TriggerScanLauncher<PACKET_TYPE> = this.apply { callbackMode = EstimoteScanSettings.ScanCallbackMode.FIRST_MATCH }
    override fun withLowPowerMode() = this.apply { this.powerMode = EstimoteScanSettings.ScanPowerMode.LOW_POWER }
    override fun withBalancedPowerMode() = this.apply { this.powerMode = EstimoteScanSettings.ScanPowerMode.BALANCED }
    override fun withLowLatencyPowerMode() = this.apply { this.powerMode = EstimoteScanSettings.ScanPowerMode.LOW_LATENCY }
    @Suppress("UNCHECKED_CAST")
    override fun start() = pendingIntent?.let { useCase.run(it, buildSettings(this as LAUNCHER)) } ?: object : ScanHandler {}
    abstract val buildSettings: (LAUNCHER) -> SETTINGS_TYPE

}