package com.estimote.scanning_plugin.packet_provider

import com.estimote.internal_plugins_api.scanning.*
import com.estimote.scanning_plugin.settings.*
import io.reactivex.Observable

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
internal interface PacketProvider {

    fun provideIBeacon(scanSettings: IBeaconScanSettings) : Observable<out Beacon>
    fun provideEddystoneUid(scanSettings: EddystoneScanSettings) : Observable<out EddystoneUid>
    fun provideEstimoteLocation(scanSettings: EstimoteLocationScanSettings) : Observable<out EstimoteLocation>
    fun provideEstimoteMesh(scanSettings: EstimoteMeshScanSettings): Observable<out EstimoteMesh>
    fun provideConnectivity(scanSettings: ConnectivityScanSettings): Observable<out EstimoteConnectivity>
    fun provideNearable(scanSettings: NearableScanSettings): Observable<out EstimoteNearable>
    fun provideEstimoteUwb(scanSettings: UwbScanSettings): Observable<out EstimoteUwb>
    fun provideEstimoteMirror(scanSettings: MirrorScanSettings): Observable<out EstimoteMirror>
    fun provideEstimoteTelemetryFrameA(scanSettings: EstimoteTelemetryScanSettings): Observable<out EstimoteTelemetryFrameA>
    fun provideEstimoteTelemetryFrameB(scanSettings: EstimoteTelemetryScanSettings): Observable<out EstimoteTelemetryFrameB>
    fun provideEstimoteTelemetryFull(scanSettings: EstimoteTelemetryScanSettings): Observable<out EstimoteTelemetryFull>
    fun provideEstimoteSecure(scanSettings: EstimoteSecureScanSettings): Observable<out EstimoteSecure>
    fun provideEstimoteRescue(scanSettings: EstimoteRescueScanSettings): Observable<out EstimoteRescue>
}