package com.estimote.scanning_plugin.packet_provider.scanner.filter_transformers

import android.annotation.TargetApi
import android.bluetooth.le.ScanFilter
import android.os.Build
import com.estimote.scanning_plugin.settings.EstimoteSecureScanSettings

/**
 * @author Estimote Inc. (contact@estimote.com)
 */
@TargetApi(Build.VERSION_CODES.LOLLIPOP)
internal class ToEstimoteSecureFilterTransformers(private val filterBuilderFactory: HardwareFilterBuilderFactory,
                                                  private val servicesUuidConfig: ServicesUuidConfig) : DefaultScanFiltersTransformer.ScanFilterTransformer<EstimoteSecureScanSettings> {

    private val SECURE_PREFIX_DATA = byteArrayOf(0x0E)
    private val SECURE_PREFIX_MASK = byteArrayOf(0x00)

    override fun transform(settings: EstimoteSecureScanSettings): List<ScanFilter> {
        return listOf(filterBuilderFactory.newBuilder().setServiceData(servicesUuidConfig.estimoteUUID, SECURE_PREFIX_DATA, SECURE_PREFIX_MASK).build())
    }
}