package com.estimote.scanning_plugin.api.scan_launchers

import com.estimote.internal_plugins_api.scanning.BluetoothScanner
import com.estimote.internal_plugins_api.scanning.EstimoteMirror
import com.estimote.scanning_plugin.api.use_cases.ScanUseCase
import com.estimote.scanning_plugin.settings.EstimoteScanSettings
import com.estimote.scanning_plugin.settings.MirrorScanSettings

/**
 * @author lukasz.pobereznik@estimote.com (Lukasz Pobereznik).
 */
internal class SimpleEstimoteMirrorScannerScanLauncher(useCase: ScanUseCase<MirrorScanSettings, EstimoteMirror>) : BaseScannerScanLauncher<MirrorScanSettings, EstimoteMirror, SimpleEstimoteMirrorScannerScanLauncher>(useCase), BluetoothScanner.EstimoteMirrorScannerScanLauncher {
    override val buildSettings: (SimpleEstimoteMirrorScannerScanLauncher) -> MirrorScanSettings = { MirrorScanSettings(it.powerMode, EstimoteScanSettings.ScanCallbackMode.ALL_MATCH) }
}