/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.scanning_plugin.packet_provider.scanner;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import com.estimote.scanning_plugin.packet_provider.scanner.EstimoteScanResult;
import com.estimote.scanning_plugin.packet_provider.scanner.PostLollipopEstimoteScanner;
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteScanner;
import com.estimote.scanning_plugin.settings.EstimoteScanSettings;
import com.estimote.scanning_plugin.settings.ScanSettingsVisitor;
import com.wafel.skald.api.LoggerApiKt;
import com.wafel.skald.api.SkaldLogger;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.functions.Cancellable;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0005\u00a2\u0006\u0002\u0010\nJ5\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\u0014\b\u0002\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u000e0\u0014H\u0082\bJ\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J\f\u0010\u001b\u001a\u00020\u0018*\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/estimote/scanning_plugin/packet_provider/scanner/PostLollipopEstimoteScanner;", "Lcom/estimote/scanning_plugin/packet_provider/use_cases/EstimoteScanner;", "bluetoothLeScanner", "Landroid/bluetooth/le/BluetoothLeScanner;", "scanSettingsTransformer", "Lcom/estimote/scanning_plugin/settings/ScanSettingsVisitor;", "Landroid/bluetooth/le/ScanSettings;", "scanFiltersTransformer", "", "Landroid/bluetooth/le/ScanFilter;", "(Landroid/bluetooth/le/BluetoothLeScanner;Lcom/estimote/scanning_plugin/settings/ScanSettingsVisitor;Lcom/estimote/scanning_plugin/settings/ScanSettingsVisitor;)V", "logger", "Lcom/wafel/skald/api/SkaldLogger;", "catchBluetoothErrors", "", "message", "", "action", "Lkotlin/Function0;", "errorAction", "Lkotlin/Function1;", "", "scan", "Lio/reactivex/Observable;", "Lcom/estimote/scanning_plugin/packet_provider/scanner/EstimoteScanResult;", "scanSettings", "Lcom/estimote/scanning_plugin/settings/EstimoteScanSettings;", "toEstimoteScanResult", "Landroid/bluetooth/le/ScanResult;", "scanning-plugin_release"})
@TargetApi(value=21)
public final class PostLollipopEstimoteScanner
implements EstimoteScanner {
    private final SkaldLogger logger;
    private final BluetoothLeScanner bluetoothLeScanner;
    private final ScanSettingsVisitor<ScanSettings> scanSettingsTransformer;
    private final ScanSettingsVisitor<List<ScanFilter>> scanFiltersTransformer;

    @Override
    @TargetApi(value=24)
    @NotNull
    public Observable<EstimoteScanResult> scan(@NotNull EstimoteScanSettings scanSettings) {
        Intrinsics.checkParameterIsNotNull((Object)scanSettings, (String)"scanSettings");
        Observable observable = Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<T>(this, scanSettings){
            final /* synthetic */ PostLollipopEstimoteScanner this$0;
            final /* synthetic */ EstimoteScanSettings $scanSettings;

            /*
             * WARNING - void declaration
             */
            public final void subscribe(@NotNull ObservableEmitter<EstimoteScanResult> emitter) {
                Intrinsics.checkParameterIsNotNull(emitter, (String)"emitter");
                ScanCallback callback2 = new ScanCallback(this, emitter){
                    final /* synthetic */ scan.1 this$0;
                    final /* synthetic */ ObservableEmitter $emitter;

                    public void onScanResult(int callbackType, @NotNull ScanResult result) {
                        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
                        this.$emitter.onNext((Object)PostLollipopEstimoteScanner.access$toEstimoteScanResult(this.this$0.this$0, result));
                    }

                    public void onBatchScanResults(@NotNull List<ScanResult> results) {
                        Intrinsics.checkParameterIsNotNull(results, (String)"results");
                        Iterable $receiver$iv = results;
                        for (T element$iv : $receiver$iv) {
                            ScanResult it = (ScanResult)element$iv;
                            this.$emitter.onNext((Object)PostLollipopEstimoteScanner.access$toEstimoteScanResult(this.this$0.this$0, it));
                        }
                    }

                    public void onScanFailed(int errorCode) {
                        ObservableEmitter observableEmitter = this.$emitter;
                        Intrinsics.checkExpressionValueIsNotNull((Object)observableEmitter, (String)"emitter");
                        if (!observableEmitter.isDisposed()) {
                            this.$emitter.onError((Throwable)new Exception("Bluetooth Low Energy scan failed with error code: " + errorCode));
                        }
                    }
                    {
                        this.this$0 = $outer;
                        this.$emitter = $captured_local_variable$1;
                    }
                };
                emitter.setCancellable(new Cancellable(this, callback2){
                    final /* synthetic */ scan.1 this$0;
                    final /* synthetic */ scan.callback.1 $callback;

                    /*
                     * WARNING - void declaration
                     */
                    public final void cancel() {
                        PostLollipopEstimoteScanner postLollipopEstimoteScanner = this.this$0.this$0;
                        String message$iv = "Unable to stop scan while Bluetooth Adapter is not turned ON (Bluetooth is probably disabled)";
                        try {
                            PostLollipopEstimoteScanner.access$getBluetoothLeScanner$p(this.this$0.this$0).stopScan((ScanCallback)this.$callback);
                        }
                        catch (IllegalStateException e$iv) {
                            void this_$iv;
                            PostLollipopEstimoteScanner.access$getLogger$p((PostLollipopEstimoteScanner)this_$iv).warn(message$iv);
                            Throwable it = new IllegalStateException(message$iv);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$callback = var2_2;
                    }
                });
                PostLollipopEstimoteScanner postLollipopEstimoteScanner = this.this$0;
                String message$iv = "Unable to start scan while Bluetooth Adapter is not turned ON (Bluetooth is probably disabled)";
                try {
                    PostLollipopEstimoteScanner.access$getBluetoothLeScanner$p(this.this$0).startScan((List)this.$scanSettings.accept(PostLollipopEstimoteScanner.access$getScanFiltersTransformer$p(this.this$0)), (ScanSettings)this.$scanSettings.accept(PostLollipopEstimoteScanner.access$getScanSettingsTransformer$p(this.this$0)), callback2);
                }
                catch (IllegalStateException e$iv) {
                    void this_$iv;
                    PostLollipopEstimoteScanner.access$getLogger$p((PostLollipopEstimoteScanner)this_$iv).warn(message$iv);
                    Throwable it = new IllegalStateException(message$iv);
                    emitter.onError(it);
                }
            }
            {
                this.this$0 = postLollipopEstimoteScanner;
                this.$scanSettings = estimoteScanSettings;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"Observable.create { emit\u2026.onError(it) })\n        }");
        return observable;
    }

    private final EstimoteScanResult toEstimoteScanResult(@NotNull ScanResult $receiver) {
        BluetoothDevice bluetoothDevice = $receiver.getDevice();
        Intrinsics.checkExpressionValueIsNotNull((Object)bluetoothDevice, (String)"device");
        int n = $receiver.getRssi();
        long l = $receiver.getTimestampNanos();
        ScanRecord scanRecord = $receiver.getScanRecord();
        Intrinsics.checkExpressionValueIsNotNull((Object)scanRecord, (String)"scanRecord");
        return new EstimoteScanResult(bluetoothDevice, n, l, scanRecord);
    }

    private final void catchBluetoothErrors(String message, Function0<Unit> action, Function1<? super Throwable, Unit> errorAction) {
        try {
            action.invoke();
        }
        catch (IllegalStateException e) {
            this.logger.warn(message);
            errorAction.invoke((Object)new IllegalStateException(message));
        }
    }

    static /* bridge */ /* synthetic */ void catchBluetoothErrors$default(PostLollipopEstimoteScanner this_, String message, Function0 action, Function1 errorAction, int n, Object object) {
        if ((n & 4) != 0) {
            errorAction = catchBluetoothErrors.1.INSTANCE;
        }
        try {
            action.invoke();
        }
        catch (IllegalStateException e) {
            this_.logger.warn(message);
            errorAction.invoke((Object)new IllegalStateException(message));
        }
    }

    public PostLollipopEstimoteScanner(@NotNull BluetoothLeScanner bluetoothLeScanner, @NotNull ScanSettingsVisitor<ScanSettings> scanSettingsTransformer, @NotNull ScanSettingsVisitor<? extends List<ScanFilter>> scanFiltersTransformer) {
        Intrinsics.checkParameterIsNotNull((Object)bluetoothLeScanner, (String)"bluetoothLeScanner");
        Intrinsics.checkParameterIsNotNull(scanSettingsTransformer, (String)"scanSettingsTransformer");
        Intrinsics.checkParameterIsNotNull(scanFiltersTransformer, (String)"scanFiltersTransformer");
        this.bluetoothLeScanner = bluetoothLeScanner;
        this.scanSettingsTransformer = scanSettingsTransformer;
        this.scanFiltersTransformer = scanFiltersTransformer;
        this.logger = LoggerApiKt.createLogger(this.getClass());
    }

    @NotNull
    public static final /* synthetic */ EstimoteScanResult access$toEstimoteScanResult(PostLollipopEstimoteScanner $this, @NotNull ScanResult $receiver) {
        return $this.toEstimoteScanResult($receiver);
    }

    @NotNull
    public static final /* synthetic */ BluetoothLeScanner access$getBluetoothLeScanner$p(PostLollipopEstimoteScanner $this) {
        return $this.bluetoothLeScanner;
    }

    public static final /* synthetic */ void access$catchBluetoothErrors(PostLollipopEstimoteScanner $this, @NotNull String message, @NotNull Function0 action, @NotNull Function1 errorAction) {
        $this.catchBluetoothErrors(message, (Function0<Unit>)action, (Function1<? super Throwable, Unit>)errorAction);
    }

    @NotNull
    public static final /* synthetic */ ScanSettingsVisitor access$getScanFiltersTransformer$p(PostLollipopEstimoteScanner $this) {
        return $this.scanFiltersTransformer;
    }

    @NotNull
    public static final /* synthetic */ ScanSettingsVisitor access$getScanSettingsTransformer$p(PostLollipopEstimoteScanner $this) {
        return $this.scanSettingsTransformer;
    }
}

