package com.estimote.scanning_plugin.packet_provider.use_cases

import android.annotation.TargetApi
import android.os.Build
import com.estimote.scanning_plugin.packet_provider.EstimoteUwbPacket
import com.estimote.scanning_plugin.packet_provider.rssi_smoothers.RssiSmoother
import com.estimote.scanning_plugin.settings.UwbScanSettings
import io.reactivex.Observable

/**
 * @author arek.biela@estimote.com (Arek Biela).
 */
internal class EstimoteUwbScanUseCase(private val estimoteScanner: EstimoteScanner,
                                      private val recognizer: EstimoteScanResultRecognizer,
                                      private val parser: EstimoteScanResultParser<EstimoteUwbPacket>,
                                      private val rssiSmootherCache: ExpirationCache<String, RssiSmoother>) {

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    fun run(scanSettings: UwbScanSettings): Observable<EstimoteUwbPacket> {
        return estimoteScanner.scan(scanSettings)
                .filter { recognizer.recognize(it) }
                .map { parser.parse(it) }
                .map { it.smoothRssi() }
    }

    private fun EstimoteUwbPacket.smoothRssi(): EstimoteUwbPacket {
        val smoother = rssiSmootherCache.get(macAddress.address)
        val smoothedRssi = smoother.smooth(rssi, this.timestamp/ 1000000000.0)
        return this.copy(rssi = smoothedRssi.toInt())
    }
}