package com.estimote.scanning_plugin.packet_provider.scanner.filter_transformers

import android.annotation.TargetApi
import android.os.Build
import com.estimote.scanning_plugin.packet_provider.scanner.filter_transformers.DefaultScanFiltersTransformer.ScanFilterTransformer
import com.estimote.scanning_plugin.settings.EddystoneScanSettings

@TargetApi(Build.VERSION_CODES.LOLLIPOP)
internal class ToEddystoneFilterTransformer(private val filterBuilderFactory: HardwareFilterBuilderFactory, private val servicesUuidConfig: ServicesUuidConfig): ScanFilterTransformer<EddystoneScanSettings> {
    override fun transform(settings: EddystoneScanSettings) =
            listOf(filterBuilderFactory.newBuilder()
                    .setServiceUuid(servicesUuidConfig.eddystoneUUID)
                    .build())
}