package com.estimote.scanning_plugin.packet_provider.recognizers

import android.annotation.TargetApi
import android.os.Build
import android.os.ParcelUuid
import com.estimote.scanning_plugin.packet_provider.scanner.EstimoteScanResult
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteScanResultRecognizer
import java.util.*

/**
 * @author arek.biela@estimote.com (Arek Biela).
 */

@TargetApi(Build.VERSION_CODES.LOLLIPOP)
internal class EstimoteTelemetryBV1Recognizer : EstimoteScanResultRecognizer {

    private val ESTIMOTE_SERVICE_UUID = ParcelUuid(UUID.fromString("0000fe9a-0000-1000-8000-00805f9b34fb"))
    private val ESTIMOTE_TELEMETRY_FRAME_TYPE = 2
    private val ESTIMOTE_TELEMETRY_SUBFRAME_B_TYPE = 1
    private val ESTIMOTE_TELEMETRY_V0_VERSION = 1
    private val ESTIMOTE_TELEMETRY_V0_FRAME_SIZE = 20

    override fun recognize(result: EstimoteScanResult): Boolean {
        return result.scanRecord.getServiceData(ESTIMOTE_SERVICE_UUID) != null
                && result.scanRecord.getServiceData(ESTIMOTE_SERVICE_UUID).isNotEmpty()
                && result.scanRecord.getServiceData(ESTIMOTE_SERVICE_UUID).size == ESTIMOTE_TELEMETRY_V0_FRAME_SIZE
                && result.scanRecord.getServiceData(ESTIMOTE_SERVICE_UUID)[9].toInt() and 0x03 == ESTIMOTE_TELEMETRY_SUBFRAME_B_TYPE
                && (result.scanRecord.getServiceData(ESTIMOTE_SERVICE_UUID)[0].toInt() and 0xF0).shr(4) == ESTIMOTE_TELEMETRY_V0_VERSION
                && result.scanRecord.getServiceData(ESTIMOTE_SERVICE_UUID)[0].toInt() and 0x0F == ESTIMOTE_TELEMETRY_FRAME_TYPE
    }
}