package com.estimote.scanning_plugin.packet_provider.parsers

import android.annotation.TargetApi
import android.os.Build
import com.estimote.scanning_plugin.common.toUnsignedInt
import com.estimote.scanning_plugin.packet_provider.BeaconPacket
import com.estimote.scanning_plugin.packet_provider.EstimoteMacAddress
import com.estimote.scanning_plugin.packet_provider.scanner.EstimoteScanResult
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteScanResultParser
import java.nio.ByteBuffer
import java.util.*

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
@TargetApi(Build.VERSION_CODES.LOLLIPOP)
internal class IBeaconParser : EstimoteScanResultParser<BeaconPacket> {
    private val APPLE_MANUFACTURER_ID = 0x004C

    override fun parse(result: EstimoteScanResult): BeaconPacket {
        val scanRecord = result.scanRecord
        val rawBytes = scanRecord.getManufacturerSpecificData(APPLE_MANUFACTURER_ID)
        val proximityUUIDBytes = Arrays.copyOfRange(rawBytes, 2, 18)
        val majorBytes = Arrays.copyOfRange(rawBytes, 18, 20)
        val minorBytes = Arrays.copyOfRange(rawBytes, 20, 22)
        val measuredPower = rawBytes[rawBytes.size - 1].toInt()
        val proximityUUIDBuffer = ByteBuffer.wrap(proximityUUIDBytes)
        val proximityUUID = UUID(proximityUUIDBuffer.long, proximityUUIDBuffer.long)
        val major = majorBytes[0].toUnsignedInt() * 0x100 + majorBytes[1].toUnsignedInt()
        val minor = minorBytes[0].toUnsignedInt() * 0x100 + minorBytes[1].toUnsignedInt()
        return BeaconPacket(proximityUUID, major, minor, EstimoteMacAddress(result.device.address), measuredPower, result.rssi, result.timestampNanosSinceBoot)
    }

}