package com.estimote.scanning_plugin.packet_provider.parsers

import com.estimote.internal_plugins_api.scanning.DeviceType
import com.estimote.scanning_plugin.packet_provider.EstimoteConnectivityPacket
import com.estimote.scanning_plugin.packet_provider.EstimoteMacAddress
import com.estimote.scanning_plugin.packet_provider.scanner.EstimoteScanResult
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteScanResultParser

/**
 * @author Estimote Inc. (contact@estimote.com)
 */
internal class EstimoteConnectivityIBeaconParser : EstimoteScanResultParser<EstimoteConnectivityPacket> {

    override fun parse(result: EstimoteScanResult): EstimoteConnectivityPacket {
        return EstimoteConnectivityPacket(
                result.device.address.replace(":", ""),
               DeviceType.PROXIMITY_BEACON,
                "unknown",
                "unknown",
                false,
                false,
                EstimoteMacAddress(result.device.address),
                result.rssi,
                result.timestampNanosSinceBoot
        )
    }

}