package com.estimote.scanning_plugin.packet_provider.scanner.filter_transformers

import android.annotation.TargetApi
import android.os.Build
import com.estimote.scanning_plugin.packet_provider.scanner.filter_transformers.DefaultScanFiltersTransformer.ScanFilterTransformer
import com.estimote.scanning_plugin.settings.EstimoteTelemetryScanSettings

@TargetApi(Build.VERSION_CODES.LOLLIPOP)
internal class ToEstimoteTelemetryFilterTransformer(private val filterBuilderFactory: HardwareFilterBuilderFactory, private val servicesUuidConfig: ServicesUuidConfig): ScanFilterTransformer<EstimoteTelemetryScanSettings> {
    private val TELEMETRY_FRAME_TYPE_DATA = byteArrayOf(0x02)
    private val TELEMETRY_FRAME_TYPE_MASK = byteArrayOf(0x0F)

    override fun transform(settings: EstimoteTelemetryScanSettings) =
            listOf(filterBuilderFactory.newBuilder()
            .setServiceData(servicesUuidConfig.estimoteUUID, TELEMETRY_FRAME_TYPE_DATA, TELEMETRY_FRAME_TYPE_MASK)
            .build())
}