package com.estimote.scanning_plugin.dagger

import android.annotation.TargetApi
import android.bluetooth.BluetoothAdapter
import android.bluetooth.BluetoothManager
import android.content.Context
import android.os.Build
import com.estimote.scanning_plugin.packet_provider.scanner.BluetoothLeScannerProvider
import dagger.Module
import dagger.Provides

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
@Module
@TargetApi(Build.VERSION_CODES.LOLLIPOP)
internal class BluetoothModule(private val applicationContext: Context) {

    @Provides
    @EstimoteScanningSdkScope
    fun providesBluetoothManager() = applicationContext.getSystemService(Context.BLUETOOTH_SERVICE) as BluetoothManager

    @Provides
    @EstimoteScanningSdkScope
    fun providesBluetoothAdapter(bluetoothManager: BluetoothManager):BluetoothAdapter? = bluetoothManager.adapter

    @Provides
    @EstimoteScanningSdkScope
    fun providesBluetoothLeScanner(bluetoothAdapter: BluetoothAdapter?): BluetoothLeScannerProvider {
        return BluetoothLeScannerProvider(bluetoothAdapter)
    }
}