package com.estimote.scanning_plugin.api

import com.estimote.internal_plugins_api.scanning.BluetoothScanner
import com.estimote.scanning_plugin.api.scan_launchers.*
import com.estimote.scanning_plugin.api.use_cases.ScanUseCase
import com.estimote.scanning_plugin.packet_provider.PacketProvider
import io.reactivex.Observable


internal class EstimoteBluetoothScanner(private val packetProvider: () -> Observable<PacketProvider>) : BluetoothScanner {

    override fun beaconScan() =
            SimpleBeaconScannerScanLauncher(ScanUseCase(packetProvider, { packetProvider, settings -> packetProvider.provideIBeacon(settings) }))

    override fun estimoteLocationScan() =
            SimpleEstimoteLocationScannerScanLauncher(ScanUseCase(packetProvider, { packetProvider, settings -> packetProvider.provideEstimoteLocation(settings) }))

    override fun eddystoneUidScan() =
            SimpleEddystoneUidScannerScanLauncher(ScanUseCase(packetProvider, { packetProvider, settings -> packetProvider.provideEddystoneUid(settings) }))

    override fun estimoteMeshScan() =
            SimpleEstimoteMeshScannerScanLauncher(ScanUseCase(packetProvider, { packetProvider, settings -> packetProvider.provideEstimoteMesh(settings) }))

    override fun estimoteConnectivityScan() =
            SimpleEstimoteConnectivityScannerScanLauncher(ScanUseCase(packetProvider, { packetProvider, settings -> packetProvider.provideConnectivity(settings) }))

    override fun estimoteNearableScan() =
            SimpleEstimoteNearableScannerScanLauncher(ScanUseCase(packetProvider, { packetProvider, settings -> packetProvider.provideNearable(settings) }))

    override fun estimoteUwbScan() =
            SimpleEstimoteUwbScannerScanLauncher(ScanUseCase(packetProvider, { packetProvider, settings -> packetProvider.provideEstimoteUwb(settings) }))

    override fun estimoteMirrorScan() =
            SimpleEstimoteMirrorScannerScanLauncher(ScanUseCase(packetProvider, { packetProvider, settings -> packetProvider.provideEstimoteMirror(settings) }))

    override fun estimoteTelemetryFrameAScan() =
            SimpleEstimoteTelemetryFrameAScannerScanLauncher(ScanUseCase(packetProvider, { packetProvider, settings -> packetProvider.provideEstimoteTelemetryFrameA(settings) }))

    override fun estimoteTelemetryFrameBScan() =
            SimpleEstimoteTelemetryFrameBScannerScanLauncher(ScanUseCase(packetProvider, { packetProvider, settings -> packetProvider.provideEstimoteTelemetryFrameB(settings) }))

    override fun estimoteTelemetryFullScan() =
            SimpleEstimoteTelemetryFullScannerScanLauncher(ScanUseCase(packetProvider, { packetProvider, settings -> packetProvider.provideEstimoteTelemetryFull(settings) }))

    override fun estimoteSecureScan() =
            SimpleEstimoteSecureScanLauncher(ScanUseCase(packetProvider, { packetProvider, settings -> packetProvider.provideEstimoteSecure(settings) }))

    override fun estimoteRescueScan() =
            SimpleEstimoteRescueScannerScanLauncher(ScanUseCase(packetProvider, { packetProvider, settings -> packetProvider.provideEstimoteRescue(settings) }))
}