package com.estimote.scanning_plugin.dagger

import com.estimote.scanning_plugin.api.EstimoteBluetoothScannerFactory
import com.estimote.scanning_plugin.packet_provider.service.PacketProviderWrapperService
import dagger.Component

@EstimoteScanningSdkScope
@Component(modules = arrayOf(
        EstimoteScanningSdkModule::class,
        BluetoothModule::class,
        ScannerModule::class,
        UseCaseModule::class,
        PacketProviderModule::class,
        ScanSettingsTransformersModule::class,
        BluetoothTriggerModule::class))
internal interface EstimoteScanningSdkComponent {
    fun inject(bluetoothScannerFactory: EstimoteBluetoothScannerFactory)
    fun inject(packetProviderWrapperService: PacketProviderWrapperService)
}