/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.scanning_plugin.packet_provider.parsers;

import android.annotation.TargetApi;
import android.bluetooth.le.ScanRecord;
import com.estimote.scanning_plugin.common.ByteExtensionsKt;
import com.estimote.scanning_plugin.packet_provider.BeaconPacket;
import com.estimote.scanning_plugin.packet_provider.EstimoteMacAddress;
import com.estimote.scanning_plugin.packet_provider.scanner.EstimoteScanResult;
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteScanResultParser;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/estimote/scanning_plugin/packet_provider/parsers/IBeaconParser;", "Lcom/estimote/scanning_plugin/packet_provider/use_cases/EstimoteScanResultParser;", "Lcom/estimote/scanning_plugin/packet_provider/BeaconPacket;", "()V", "APPLE_MANUFACTURER_ID", "", "parse", "result", "Lcom/estimote/scanning_plugin/packet_provider/scanner/EstimoteScanResult;", "scanning-plugin_release"})
@TargetApi(value=21)
public final class IBeaconParser
implements EstimoteScanResultParser<BeaconPacket> {
    private final int APPLE_MANUFACTURER_ID = 76;

    @Override
    @NotNull
    public BeaconPacket parse(@NotNull EstimoteScanResult result) {
        ByteBuffer proximityUUIDBuffer;
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        ScanRecord scanRecord = result.getScanRecord();
        byte[] rawBytes = scanRecord.getManufacturerSpecificData(this.APPLE_MANUFACTURER_ID);
        byte[] proximityUUIDBytes = Arrays.copyOfRange(rawBytes, 2, 18);
        byte[] majorBytes = Arrays.copyOfRange(rawBytes, 18, 20);
        byte[] minorBytes = Arrays.copyOfRange(rawBytes, 20, 22);
        byte measuredPower = rawBytes[rawBytes.length - 1];
        ByteBuffer byteBuffer = proximityUUIDBuffer = ByteBuffer.wrap(proximityUUIDBytes);
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"proximityUUIDBuffer");
        UUID proximityUUID = new UUID(byteBuffer.getLong(), proximityUUIDBuffer.getLong());
        int major = ByteExtensionsKt.toUnsignedInt(majorBytes[0]) * 256 + ByteExtensionsKt.toUnsignedInt(majorBytes[1]);
        int minor = ByteExtensionsKt.toUnsignedInt(minorBytes[0]) * 256 + ByteExtensionsKt.toUnsignedInt(minorBytes[1]);
        String string = result.getDevice().getAddress();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.device.address");
        return new BeaconPacket(proximityUUID, major, minor, new EstimoteMacAddress(string), measuredPower, result.getRssi(), result.getTimestampNanosSinceBoot());
    }
}

