/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.scanning_plugin.packet_provider.parsers;

import android.annotation.TargetApi;
import android.os.ParcelUuid;
import com.estimote.scanning_plugin.common.ByteExtensionsKt;
import com.estimote.scanning_plugin.packet_provider.EstimoteMacAddress;
import com.estimote.scanning_plugin.packet_provider.EstimoteMirrorPacket;
import com.estimote.scanning_plugin.packet_provider.scanner.EstimoteScanResult;
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteScanResultParser;
import java.nio.ByteBuffer;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0002J\f\u0010\f\u001a\u00020\r*\u00020\u000bH\u0002J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u000bH\u0002J\f\u0010\u0010\u001a\u00020\u000f*\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/estimote/scanning_plugin/packet_provider/parsers/EstimoteMirrorParser;", "Lcom/estimote/scanning_plugin/packet_provider/use_cases/EstimoteScanResultParser;", "Lcom/estimote/scanning_plugin/packet_provider/EstimoteMirrorPacket;", "()V", "ESTIMOTE_SERVICE_UUID", "Landroid/os/ParcelUuid;", "parse", "result", "Lcom/estimote/scanning_plugin/packet_provider/scanner/EstimoteScanResult;", "getAccessControl", "", "Ljava/nio/ByteBuffer;", "getDeviceId", "", "getMeasuredPower", "", "getProtocolVersion", "scanning-plugin_release"})
@TargetApi(value=21)
public final class EstimoteMirrorParser
implements EstimoteScanResultParser<EstimoteMirrorPacket> {
    private final ParcelUuid ESTIMOTE_SERVICE_UUID = new ParcelUuid(UUID.fromString("0000fe9a-0000-1000-8000-00805f9b34fb"));

    @Override
    @NotNull
    public EstimoteMirrorPacket parse(@NotNull EstimoteScanResult result) {
        ByteBuffer bytes;
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        ByteBuffer $receiver = bytes = ByteBuffer.wrap(result.getScanRecord().getServiceData(this.ESTIMOTE_SERVICE_UUID));
        String string = this.getDeviceId($receiver);
        String string2 = result.getDevice().getAddress();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"result.device.address");
        return new EstimoteMirrorPacket(string, new EstimoteMacAddress(string2), this.getProtocolVersion($receiver), this.getMeasuredPower($receiver), result.getRssi(), this.getAccessControl($receiver), result.getTimestampNanosSinceBoot());
    }

    private final boolean getAccessControl(@NotNull ByteBuffer $receiver) {
        return ($receiver.get(18) & 0x80) > 0;
    }

    private final String getDeviceId(@NotNull ByteBuffer $receiver) {
        byte[] idBytes = new byte[16];
        $receiver.position(1);
        $receiver.get(idBytes, 0, 16);
        return ByteExtensionsKt.toHex(idBytes);
    }

    private final int getMeasuredPower(@NotNull ByteBuffer $receiver) {
        return $receiver.get(17);
    }

    private final int getProtocolVersion(@NotNull ByteBuffer $receiver) {
        return ($receiver.get(0) & 0xF0) >> 4;
    }
}

