/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.scanning_plugin.dagger;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.ScanFilter;
import com.estimote.internal_plugins_api.scanning.BluetoothBackgroundTriggerConfigurator;
import com.estimote.scanning_plugin.api.EstimoteBluetoothScannerFactory;
import com.estimote.scanning_plugin.api.EstimoteBluetoothScannerFactory_MembersInjector;
import com.estimote.scanning_plugin.dagger.BluetoothModule;
import com.estimote.scanning_plugin.dagger.BluetoothModule_ProvidesBluetoothAdapterFactory;
import com.estimote.scanning_plugin.dagger.BluetoothModule_ProvidesBluetoothLeScannerFactory;
import com.estimote.scanning_plugin.dagger.BluetoothModule_ProvidesBluetoothManagerFactory;
import com.estimote.scanning_plugin.dagger.BluetoothTriggerModule;
import com.estimote.scanning_plugin.dagger.BluetoothTriggerModule_ProvidesBluetoothTriggerConfiguratorFactory;
import com.estimote.scanning_plugin.dagger.EstimoteScanningSdkComponent;
import com.estimote.scanning_plugin.dagger.EstimoteScanningSdkModule;
import com.estimote.scanning_plugin.dagger.EstimoteScanningSdkModule_ProvidePacketProviderServiceWrapperStarterFactory;
import com.estimote.scanning_plugin.dagger.PacketProviderModule;
import com.estimote.scanning_plugin.dagger.PacketProviderModule_ProvidesPacketProviderFactory;
import com.estimote.scanning_plugin.dagger.ScanSettingsTransformersModule;
import com.estimote.scanning_plugin.dagger.ScanSettingsTransformersModule_ProvideEstimoteSettingsToFilterTransformerFactory;
import com.estimote.scanning_plugin.dagger.ScanSettingsTransformersModule_ProvideScanSettingsTransformerProviderFactory;
import com.estimote.scanning_plugin.dagger.ScannerModule;
import com.estimote.scanning_plugin.dagger.ScannerModule_ProvideAntennaBiasCorrectionFactoryFactory;
import com.estimote.scanning_plugin.dagger.ScannerModule_ProvideScannerFactory;
import com.estimote.scanning_plugin.dagger.ScannerModule_ProvideScannerFactoryFactory;
import com.estimote.scanning_plugin.dagger.UseCaseModule;
import com.estimote.scanning_plugin.dagger.UseCaseModule_ProvideEddystoneUidScanUseCaseFactory;
import com.estimote.scanning_plugin.dagger.UseCaseModule_ProvideEstimoteConnectivityScanUseCaseFactory;
import com.estimote.scanning_plugin.dagger.UseCaseModule_ProvideEstimoteLocationScanUseCaseFactory;
import com.estimote.scanning_plugin.dagger.UseCaseModule_ProvideEstimoteMeshScanUseCaseFactory;
import com.estimote.scanning_plugin.dagger.UseCaseModule_ProvideEstimoteMirrorScanUseCaseFactory;
import com.estimote.scanning_plugin.dagger.UseCaseModule_ProvideEstimoteNearableScanUseCaseFactory;
import com.estimote.scanning_plugin.dagger.UseCaseModule_ProvideEstimoteRescueScanUseCaseFactory;
import com.estimote.scanning_plugin.dagger.UseCaseModule_ProvideEstimoteSecureScanUseCaseFactory;
import com.estimote.scanning_plugin.dagger.UseCaseModule_ProvideEstimoteTelemetryAV0ScanUseCaseFactory;
import com.estimote.scanning_plugin.dagger.UseCaseModule_ProvideEstimoteTelemetryAV1ScanUseCaseFactory;
import com.estimote.scanning_plugin.dagger.UseCaseModule_ProvideEstimoteTelemetryAV2ScanUseCaseFactory;
import com.estimote.scanning_plugin.dagger.UseCaseModule_ProvideEstimoteTelemetryBV0ScanUseCaseFactory;
import com.estimote.scanning_plugin.dagger.UseCaseModule_ProvideEstimoteTelemetryBV1ScanUseCaseFactory;
import com.estimote.scanning_plugin.dagger.UseCaseModule_ProvideEstimoteTelemetryBV2ScanUseCaseFactory;
import com.estimote.scanning_plugin.dagger.UseCaseModule_ProvideEstimoteTelemetryFullUseCaseFactory;
import com.estimote.scanning_plugin.dagger.UseCaseModule_ProvideEstimoteUwbScanUseCaseFactory;
import com.estimote.scanning_plugin.dagger.UseCaseModule_ProvideIBeaconScanUseCaseFactory;
import com.estimote.scanning_plugin.dagger.UseCaseModule_ProvideRssiExpirationCacheFactoryFactory;
import com.estimote.scanning_plugin.dagger.UseCaseModule_ProvideTelemetryMergerFactory;
import com.estimote.scanning_plugin.dagger.UseCaseModule_ProvideTimerFactory;
import com.estimote.scanning_plugin.packet_provider.PacketProvider;
import com.estimote.scanning_plugin.packet_provider.antenna_bias.AntennaBiasCorrection;
import com.estimote.scanning_plugin.packet_provider.rssi_smoothers.RssiSmootherExpirationCacheFactory;
import com.estimote.scanning_plugin.packet_provider.rssi_smoothers.Timer;
import com.estimote.scanning_plugin.packet_provider.scanner.BluetoothLeScannerProvider;
import com.estimote.scanning_plugin.packet_provider.scanner.ScannerFactory;
import com.estimote.scanning_plugin.packet_provider.scanner.settings_transformers.ScanSettingsTransformerProvider;
import com.estimote.scanning_plugin.packet_provider.service.PacketProviderWrapperService;
import com.estimote.scanning_plugin.packet_provider.service.PacketProviderWrapperServiceHelper;
import com.estimote.scanning_plugin.packet_provider.service.PacketProviderWrapperService_MembersInjector;
import com.estimote.scanning_plugin.packet_provider.telemetry_merger.TelemetryMerger;
import com.estimote.scanning_plugin.packet_provider.use_cases.EddystoneUidScanUseCase;
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteConnectivityScanUseCase;
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteLocationScanUseCase;
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteMeshScanUseCase;
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteMirrorScanUseCase;
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteNearableScanUseCase;
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteRescueScanUseCase;
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteScanner;
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteSecureScanUseCase;
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteTelemetryAV0ScanUseCase;
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteTelemetryAV1ScanUseCase;
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteTelemetryAV2ScanUseCase;
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteTelemetryBV0ScanUseCase;
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteTelemetryBV1ScanUseCase;
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteTelemetryBV2ScanUseCase;
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteTelemetryFullScanUseCase;
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteUwbScanUseCase;
import com.estimote.scanning_plugin.packet_provider.use_cases.IBeaconScanUseCase;
import com.estimote.scanning_plugin.settings.ScanSettingsVisitor;
import dagger.MembersInjector;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import java.util.List;
import javax.inject.Provider;

public final class DaggerEstimoteScanningSdkComponent
implements EstimoteScanningSdkComponent {
    private Provider<BluetoothManager> providesBluetoothManagerProvider;
    private Provider<BluetoothAdapter> providesBluetoothAdapterProvider;
    private Provider<BluetoothLeScannerProvider> providesBluetoothLeScannerProvider;
    private Provider<ScanSettingsTransformerProvider> provideScanSettingsTransformerProvider;
    private Provider<ScanSettingsVisitor<? extends List<ScanFilter>>> provideEstimoteSettingsToFilterTransformerProvider;
    private Provider<ScannerFactory> provideScannerFactoryProvider;
    private Provider<EstimoteScanner> provideScannerProvider;
    private Provider<Timer> provideTimerProvider;
    private Provider<RssiSmootherExpirationCacheFactory> provideRssiExpirationCacheFactoryProvider;
    private Provider<AntennaBiasCorrection> provideAntennaBiasCorrectionFactoryProvider;
    private Provider<IBeaconScanUseCase> provideIBeaconScanUseCaseProvider;
    private Provider<EddystoneUidScanUseCase> provideEddystoneUidScanUseCaseProvider;
    private Provider<EstimoteLocationScanUseCase> provideEstimoteLocationScanUseCaseProvider;
    private Provider<EstimoteMeshScanUseCase> provideEstimoteMeshScanUseCaseProvider;
    private Provider<EstimoteConnectivityScanUseCase> provideEstimoteConnectivityScanUseCaseProvider;
    private Provider<EstimoteNearableScanUseCase> provideEstimoteNearableScanUseCaseProvider;
    private Provider<EstimoteUwbScanUseCase> provideEstimoteUwbScanUseCaseProvider;
    private Provider<EstimoteMirrorScanUseCase> provideEstimoteMirrorScanUseCaseProvider;
    private Provider<EstimoteTelemetryAV0ScanUseCase> provideEstimoteTelemetryAV0ScanUseCaseProvider;
    private Provider<EstimoteTelemetryAV1ScanUseCase> provideEstimoteTelemetryAV1ScanUseCaseProvider;
    private Provider<EstimoteTelemetryAV2ScanUseCase> provideEstimoteTelemetryAV2ScanUseCaseProvider;
    private Provider<EstimoteTelemetryBV0ScanUseCase> provideEstimoteTelemetryBV0ScanUseCaseProvider;
    private Provider<EstimoteTelemetryBV1ScanUseCase> provideEstimoteTelemetryBV1ScanUseCaseProvider;
    private Provider<EstimoteTelemetryBV2ScanUseCase> provideEstimoteTelemetryBV2ScanUseCaseProvider;
    private Provider<TelemetryMerger> provideTelemetryMergerProvider;
    private Provider<EstimoteTelemetryFullScanUseCase> provideEstimoteTelemetryFullUseCaseProvider;
    private Provider<EstimoteSecureScanUseCase> provideEstimoteSecureScanUseCaseProvider;
    private Provider<EstimoteRescueScanUseCase> provideEstimoteRescueScanUseCaseProvider;
    private Provider<PacketProvider> providesPacketProvider;
    private Provider<PacketProviderWrapperServiceHelper> providePacketProviderServiceWrapperStarterProvider;
    private Provider<BluetoothBackgroundTriggerConfigurator> providesBluetoothTriggerConfiguratorProvider;
    private MembersInjector<EstimoteBluetoothScannerFactory> estimoteBluetoothScannerFactoryMembersInjector;
    private MembersInjector<PacketProviderWrapperService> packetProviderWrapperServiceMembersInjector;

    private DaggerEstimoteScanningSdkComponent(Builder builder) {
        assert (builder != null);
        this.initialize(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    private void initialize(Builder builder) {
        this.providesBluetoothManagerProvider = DoubleCheck.provider(BluetoothModule_ProvidesBluetoothManagerFactory.create(builder.bluetoothModule));
        this.providesBluetoothAdapterProvider = DoubleCheck.provider(BluetoothModule_ProvidesBluetoothAdapterFactory.create(builder.bluetoothModule, this.providesBluetoothManagerProvider));
        this.providesBluetoothLeScannerProvider = DoubleCheck.provider(BluetoothModule_ProvidesBluetoothLeScannerFactory.create(builder.bluetoothModule, this.providesBluetoothAdapterProvider));
        this.provideScanSettingsTransformerProvider = DoubleCheck.provider(ScanSettingsTransformersModule_ProvideScanSettingsTransformerProviderFactory.create(builder.scanSettingsTransformersModule));
        this.provideEstimoteSettingsToFilterTransformerProvider = DoubleCheck.provider(ScanSettingsTransformersModule_ProvideEstimoteSettingsToFilterTransformerFactory.create(builder.scanSettingsTransformersModule, this.providesBluetoothAdapterProvider));
        this.provideScannerFactoryProvider = DoubleCheck.provider(ScannerModule_ProvideScannerFactoryFactory.create(builder.scannerModule, this.providesBluetoothLeScannerProvider, this.provideScanSettingsTransformerProvider, this.provideEstimoteSettingsToFilterTransformerProvider));
        this.provideScannerProvider = DoubleCheck.provider(ScannerModule_ProvideScannerFactory.create(builder.scannerModule, this.provideScannerFactoryProvider));
        this.provideTimerProvider = DoubleCheck.provider(UseCaseModule_ProvideTimerFactory.create(builder.useCaseModule));
        this.provideRssiExpirationCacheFactoryProvider = DoubleCheck.provider(UseCaseModule_ProvideRssiExpirationCacheFactoryFactory.create(builder.useCaseModule, this.provideTimerProvider));
        this.provideAntennaBiasCorrectionFactoryProvider = DoubleCheck.provider(ScannerModule_ProvideAntennaBiasCorrectionFactoryFactory.create(builder.scannerModule));
        this.provideIBeaconScanUseCaseProvider = DoubleCheck.provider(UseCaseModule_ProvideIBeaconScanUseCaseFactory.create(builder.useCaseModule, this.provideScannerProvider, this.provideRssiExpirationCacheFactoryProvider, this.provideAntennaBiasCorrectionFactoryProvider));
        this.provideEddystoneUidScanUseCaseProvider = DoubleCheck.provider(UseCaseModule_ProvideEddystoneUidScanUseCaseFactory.create(builder.useCaseModule, this.provideScannerProvider, this.provideRssiExpirationCacheFactoryProvider));
        this.provideEstimoteLocationScanUseCaseProvider = DoubleCheck.provider(UseCaseModule_ProvideEstimoteLocationScanUseCaseFactory.create(builder.useCaseModule, this.provideScannerProvider, this.provideRssiExpirationCacheFactoryProvider, this.provideAntennaBiasCorrectionFactoryProvider));
        this.provideEstimoteMeshScanUseCaseProvider = DoubleCheck.provider(UseCaseModule_ProvideEstimoteMeshScanUseCaseFactory.create(builder.useCaseModule, this.provideScannerProvider, this.provideRssiExpirationCacheFactoryProvider));
        this.provideEstimoteConnectivityScanUseCaseProvider = DoubleCheck.provider(UseCaseModule_ProvideEstimoteConnectivityScanUseCaseFactory.create(builder.useCaseModule, this.provideScannerProvider, this.provideRssiExpirationCacheFactoryProvider));
        this.provideEstimoteNearableScanUseCaseProvider = DoubleCheck.provider(UseCaseModule_ProvideEstimoteNearableScanUseCaseFactory.create(builder.useCaseModule, this.provideScannerProvider, this.provideRssiExpirationCacheFactoryProvider));
        this.provideEstimoteUwbScanUseCaseProvider = DoubleCheck.provider(UseCaseModule_ProvideEstimoteUwbScanUseCaseFactory.create(builder.useCaseModule, this.provideScannerProvider, this.provideRssiExpirationCacheFactoryProvider));
        this.provideEstimoteMirrorScanUseCaseProvider = DoubleCheck.provider(UseCaseModule_ProvideEstimoteMirrorScanUseCaseFactory.create(builder.useCaseModule, this.provideScannerProvider, this.provideRssiExpirationCacheFactoryProvider, this.provideAntennaBiasCorrectionFactoryProvider));
        this.provideEstimoteTelemetryAV0ScanUseCaseProvider = DoubleCheck.provider(UseCaseModule_ProvideEstimoteTelemetryAV0ScanUseCaseFactory.create(builder.useCaseModule, this.provideScannerProvider, this.provideRssiExpirationCacheFactoryProvider));
        this.provideEstimoteTelemetryAV1ScanUseCaseProvider = DoubleCheck.provider(UseCaseModule_ProvideEstimoteTelemetryAV1ScanUseCaseFactory.create(builder.useCaseModule, this.provideScannerProvider, this.provideRssiExpirationCacheFactoryProvider));
        this.provideEstimoteTelemetryAV2ScanUseCaseProvider = DoubleCheck.provider(UseCaseModule_ProvideEstimoteTelemetryAV2ScanUseCaseFactory.create(builder.useCaseModule, this.provideScannerProvider, this.provideRssiExpirationCacheFactoryProvider));
        this.provideEstimoteTelemetryBV0ScanUseCaseProvider = DoubleCheck.provider(UseCaseModule_ProvideEstimoteTelemetryBV0ScanUseCaseFactory.create(builder.useCaseModule, this.provideScannerProvider, this.provideRssiExpirationCacheFactoryProvider));
        this.provideEstimoteTelemetryBV1ScanUseCaseProvider = DoubleCheck.provider(UseCaseModule_ProvideEstimoteTelemetryBV1ScanUseCaseFactory.create(builder.useCaseModule, this.provideScannerProvider, this.provideRssiExpirationCacheFactoryProvider));
        this.provideEstimoteTelemetryBV2ScanUseCaseProvider = DoubleCheck.provider(UseCaseModule_ProvideEstimoteTelemetryBV2ScanUseCaseFactory.create(builder.useCaseModule, this.provideScannerProvider, this.provideRssiExpirationCacheFactoryProvider));
        this.provideTelemetryMergerProvider = DoubleCheck.provider(UseCaseModule_ProvideTelemetryMergerFactory.create(builder.useCaseModule));
        this.provideEstimoteTelemetryFullUseCaseProvider = DoubleCheck.provider(UseCaseModule_ProvideEstimoteTelemetryFullUseCaseFactory.create(builder.useCaseModule, this.provideTelemetryMergerProvider));
        this.provideEstimoteSecureScanUseCaseProvider = DoubleCheck.provider(UseCaseModule_ProvideEstimoteSecureScanUseCaseFactory.create(builder.useCaseModule, this.provideScannerProvider, this.provideRssiExpirationCacheFactoryProvider));
        this.provideEstimoteRescueScanUseCaseProvider = DoubleCheck.provider(UseCaseModule_ProvideEstimoteRescueScanUseCaseFactory.create(builder.useCaseModule, this.provideScannerProvider, this.provideRssiExpirationCacheFactoryProvider));
        this.providesPacketProvider = DoubleCheck.provider(PacketProviderModule_ProvidesPacketProviderFactory.create(builder.packetProviderModule, this.provideIBeaconScanUseCaseProvider, this.provideEddystoneUidScanUseCaseProvider, this.provideEstimoteLocationScanUseCaseProvider, this.provideEstimoteMeshScanUseCaseProvider, this.provideEstimoteConnectivityScanUseCaseProvider, this.provideEstimoteNearableScanUseCaseProvider, this.provideEstimoteUwbScanUseCaseProvider, this.provideEstimoteMirrorScanUseCaseProvider, this.provideEstimoteTelemetryAV0ScanUseCaseProvider, this.provideEstimoteTelemetryAV1ScanUseCaseProvider, this.provideEstimoteTelemetryAV2ScanUseCaseProvider, this.provideEstimoteTelemetryBV0ScanUseCaseProvider, this.provideEstimoteTelemetryBV1ScanUseCaseProvider, this.provideEstimoteTelemetryBV2ScanUseCaseProvider, this.provideEstimoteTelemetryFullUseCaseProvider, this.provideEstimoteSecureScanUseCaseProvider, this.provideEstimoteRescueScanUseCaseProvider));
        this.providePacketProviderServiceWrapperStarterProvider = DoubleCheck.provider(EstimoteScanningSdkModule_ProvidePacketProviderServiceWrapperStarterFactory.create(builder.estimoteScanningSdkModule));
        this.providesBluetoothTriggerConfiguratorProvider = DoubleCheck.provider(BluetoothTriggerModule_ProvidesBluetoothTriggerConfiguratorFactory.create(builder.bluetoothTriggerModule, this.providesBluetoothAdapterProvider, this.provideScanSettingsTransformerProvider));
        this.estimoteBluetoothScannerFactoryMembersInjector = EstimoteBluetoothScannerFactory_MembersInjector.create(this.providesPacketProvider, this.providePacketProviderServiceWrapperStarterProvider, this.providesBluetoothTriggerConfiguratorProvider);
        this.packetProviderWrapperServiceMembersInjector = PacketProviderWrapperService_MembersInjector.create(this.providePacketProviderServiceWrapperStarterProvider, this.providesPacketProvider);
    }

    @Override
    public void inject(EstimoteBluetoothScannerFactory bluetoothScannerFactory) {
        this.estimoteBluetoothScannerFactoryMembersInjector.injectMembers((Object)bluetoothScannerFactory);
    }

    @Override
    public void inject(PacketProviderWrapperService packetProviderWrapperService) {
        this.packetProviderWrapperServiceMembersInjector.injectMembers((Object)packetProviderWrapperService);
    }

    public static final class Builder {
        private BluetoothModule bluetoothModule;
        private ScanSettingsTransformersModule scanSettingsTransformersModule;
        private ScannerModule scannerModule;
        private UseCaseModule useCaseModule;
        private PacketProviderModule packetProviderModule;
        private EstimoteScanningSdkModule estimoteScanningSdkModule;
        private BluetoothTriggerModule bluetoothTriggerModule;

        private Builder() {
        }

        public EstimoteScanningSdkComponent build() {
            if (this.bluetoothModule == null) {
                throw new IllegalStateException(BluetoothModule.class.getCanonicalName() + " must be set");
            }
            if (this.scanSettingsTransformersModule == null) {
                throw new IllegalStateException(ScanSettingsTransformersModule.class.getCanonicalName() + " must be set");
            }
            if (this.scannerModule == null) {
                throw new IllegalStateException(ScannerModule.class.getCanonicalName() + " must be set");
            }
            if (this.useCaseModule == null) {
                this.useCaseModule = new UseCaseModule();
            }
            if (this.packetProviderModule == null) {
                this.packetProviderModule = new PacketProviderModule();
            }
            if (this.estimoteScanningSdkModule == null) {
                this.estimoteScanningSdkModule = new EstimoteScanningSdkModule();
            }
            if (this.bluetoothTriggerModule == null) {
                this.bluetoothTriggerModule = new BluetoothTriggerModule();
            }
            return new DaggerEstimoteScanningSdkComponent(this);
        }

        public Builder estimoteScanningSdkModule(EstimoteScanningSdkModule estimoteScanningSdkModule) {
            this.estimoteScanningSdkModule = (EstimoteScanningSdkModule)Preconditions.checkNotNull((Object)estimoteScanningSdkModule);
            return this;
        }

        public Builder bluetoothModule(BluetoothModule bluetoothModule) {
            this.bluetoothModule = (BluetoothModule)Preconditions.checkNotNull((Object)bluetoothModule);
            return this;
        }

        public Builder scannerModule(ScannerModule scannerModule) {
            this.scannerModule = (ScannerModule)Preconditions.checkNotNull((Object)scannerModule);
            return this;
        }

        public Builder useCaseModule(UseCaseModule useCaseModule) {
            this.useCaseModule = (UseCaseModule)Preconditions.checkNotNull((Object)useCaseModule);
            return this;
        }

        public Builder packetProviderModule(PacketProviderModule packetProviderModule) {
            this.packetProviderModule = (PacketProviderModule)Preconditions.checkNotNull((Object)packetProviderModule);
            return this;
        }

        public Builder scanSettingsTransformersModule(ScanSettingsTransformersModule scanSettingsTransformersModule) {
            this.scanSettingsTransformersModule = (ScanSettingsTransformersModule)Preconditions.checkNotNull((Object)scanSettingsTransformersModule);
            return this;
        }

        public Builder bluetoothTriggerModule(BluetoothTriggerModule bluetoothTriggerModule) {
            this.bluetoothTriggerModule = (BluetoothTriggerModule)Preconditions.checkNotNull((Object)bluetoothTriggerModule);
            return this;
        }
    }
}

