package com.estimote.scanning_plugin.packet_provider.rssi_smoothers

import com.estimote.scanning_plugin.packet_provider.use_cases.ExpirationCache

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
internal class RssiSmootherExpirationCacheFactory(private val timer: Timer) : ExpirationCacheFactory<String, RssiSmoother> {

    override fun create(): ExpirationCache<String, RssiSmoother> =
            TimeExpirationCache(timer, { _ -> FastPredictiveVarianceRssiSmoother()}, TimeExpirationPolicy(1000, timer))
}