/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.scanning_plugin.packet_provider.recognizers;

import android.annotation.TargetApi;
import android.os.ParcelUuid;
import com.estimote.scanning_plugin.packet_provider.scanner.EstimoteScanResult;
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteScanResultRecognizer;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\f\u0010\u000b\u001a\u00020\b*\u00020\nH\u0002J\f\u0010\f\u001a\u00020\b*\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/estimote/scanning_plugin/packet_provider/recognizers/EddystoneUrlRecognizer;", "Lcom/estimote/scanning_plugin/packet_provider/use_cases/EstimoteScanResultRecognizer;", "()V", "EDDYSTONE_SERVICE_UUID", "Landroid/os/ParcelUuid;", "EDDYSTONE_URL_FRAME_TYPE", "", "recognize", "", "result", "Lcom/estimote/scanning_plugin/packet_provider/scanner/EstimoteScanResult;", "isEddystone", "isEddystoneUrlPacket", "scanning-plugin_release"})
@TargetApi(value=21)
public final class EddystoneUrlRecognizer
implements EstimoteScanResultRecognizer {
    private final ParcelUuid EDDYSTONE_SERVICE_UUID = new ParcelUuid(UUID.fromString("0000feaa-0000-1000-8000-00805f9b34fb"));
    private final int EDDYSTONE_URL_FRAME_TYPE = 16;

    @Override
    public boolean recognize(@NotNull EstimoteScanResult result) {
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        return this.isEddystone(result) && this.isEddystoneUrlPacket(result);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isEddystone(@NotNull EstimoteScanResult $receiver) {
        byte[] byArray;
        if (!$receiver.getScanRecord().getServiceUuids().contains(this.EDDYSTONE_SERVICE_UUID)) return false;
        if ($receiver.getScanRecord().getServiceData(this.EDDYSTONE_SERVICE_UUID) == null) return false;
        byte[] byArray2 = $receiver.getScanRecord().getServiceData(this.EDDYSTONE_SERVICE_UUID);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"scanRecord.getServiceData(EDDYSTONE_SERVICE_UUID)");
        byte[] byArray3 = byArray = byArray2;
        if (byArray3.length != 0) return true;
        return false;
    }

    private final boolean isEddystoneUrlPacket(@NotNull EstimoteScanResult $receiver) {
        byte[] data = $receiver.getScanRecord().getServiceData(this.EDDYSTONE_SERVICE_UUID);
        return (data[0] & 0xF0) == this.EDDYSTONE_URL_FRAME_TYPE;
    }
}

