/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.scanning_plugin.packet_provider.parsers;

import android.annotation.TargetApi;
import android.os.ParcelUuid;
import com.estimote.scanning_plugin.common.ByteExtensionsKt;
import com.estimote.scanning_plugin.packet_provider.EstimoteMacAddress;
import com.estimote.scanning_plugin.packet_provider.EstimoteUwbPacket;
import com.estimote.scanning_plugin.packet_provider.scanner.EstimoteScanResult;
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteScanResultParser;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0002J\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00100\u0013*\u00020\u000eH\u0002J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/estimote/scanning_plugin/packet_provider/parsers/EstimoteUwbParser;", "Lcom/estimote/scanning_plugin/packet_provider/use_cases/EstimoteScanResultParser;", "Lcom/estimote/scanning_plugin/packet_provider/EstimoteUwbPacket;", "()V", "DISTANCE_ESTIMATE_LENGTH", "", "DISTANCE_ESTIMATE_OFFSET", "ESTIMOTE_SERVICE_UUID", "Landroid/os/ParcelUuid;", "parse", "result", "Lcom/estimote/scanning_plugin/packet_provider/scanner/EstimoteScanResult;", "getDeviceId", "", "Ljava/nio/ByteBuffer;", "getDistanceEstimate", "", "", "getDistanceEstimatesMap", "", "getRangingInProgress", "", "scanning-plugin_release"})
@TargetApi(value=21)
public final class EstimoteUwbParser
implements EstimoteScanResultParser<EstimoteUwbPacket> {
    private final ParcelUuid ESTIMOTE_SERVICE_UUID = new ParcelUuid(UUID.fromString("0000fe9a-0000-1000-8000-00805f9b34fb"));
    private final int DISTANCE_ESTIMATE_LENGTH = 5;
    private final int DISTANCE_ESTIMATE_OFFSET = 4;

    @Override
    @NotNull
    public EstimoteUwbPacket parse(@NotNull EstimoteScanResult result) {
        ByteBuffer bytes;
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        ByteBuffer $receiver = bytes = ByteBuffer.wrap(result.getScanRecord().getServiceData(this.ESTIMOTE_SERVICE_UUID));
        String string = this.getDeviceId($receiver);
        Map<String, Float> map = this.getDistanceEstimatesMap($receiver);
        boolean bl = this.getRangingInProgress($receiver);
        String string2 = result.getDevice().getAddress();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"result.device.address");
        return new EstimoteUwbPacket(string, map, bl, new EstimoteMacAddress(string2), result.getRssi(), result.getTimestampNanosSinceBoot());
    }

    private final String getDeviceId(@NotNull ByteBuffer $receiver) {
        byte[] idBytes = new byte[3];
        $receiver.position(1);
        $receiver.get(idBytes, 0, 3);
        return ByteExtensionsKt.toHex(idBytes);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Float> getDistanceEstimatesMap(@NotNull ByteBuffer $receiver) {
        HashMap<String, Float> distanceEstimates = new HashMap<String, Float>();
        int n = 0;
        int n2 = 2;
        while (n <= n2) {
            void i;
            byte[] idBytes = new byte[3];
            $receiver.position((int)(i * this.DISTANCE_ESTIMATE_LENGTH + this.DISTANCE_ESTIMATE_OFFSET));
            $receiver.get(idBytes, 0, 3);
            String identifier = ByteExtensionsKt.toHex(idBytes);
            byte[] distanceBytes = new byte[2];
            $receiver.get(distanceBytes, 0, 2);
            float distanceEstimate = this.getDistanceEstimate(distanceBytes);
            distanceEstimates.put(identifier, Float.valueOf(distanceEstimate));
            ++i;
        }
        return distanceEstimates;
    }

    private final float getDistanceEstimate(@NotNull byte[] $receiver) {
        byte[] reversedDistanceBytes = ArraysKt.reversedArray((byte[])$receiver);
        String string = ByteExtensionsKt.toHex(reversedDistanceBytes);
        int n = 16;
        return (float)Long.parseLong(string, CharsKt.checkRadix((int)n)) / 256.0f;
    }

    private final boolean getRangingInProgress(@NotNull ByteBuffer $receiver) {
        byte by;
        byte by2 = $receiver.get(19);
        return (byte)(by2 & (by = 1)) > 0;
    }
}

