package com.estimote.scanning_plugin.packet_provider.service

import android.app.Notification
import android.content.ComponentName
import android.content.Context
import android.content.Intent
import android.content.ServiceConnection
import android.os.Binder
import android.os.Build
import android.os.IBinder
import com.estimote.scanning_plugin.packet_provider.PacketProvider
import io.reactivex.Observable
import io.reactivex.ObservableEmitter

internal class PacketProviderWrapperServiceHelper {
    private val NOTIFICATION_INTENT_KEY = "NOTIFICATION"

    data class LocalBinder(val service: PacketProviderWrapperService) : Binder()

    fun startAndBind(applicationContext: Context, notification: Notification): Observable<PacketProvider> =
            Observable.create<PacketProvider> { emitter ->
                startServiceWithNotification(applicationContext, notification)
                val connection: ServiceConnection = createServiceConnection(emitter)
                emitter.setCancellable { applicationContext.unbindService(connection) }
                applicationContext.bindService(Intent(applicationContext, PacketProviderWrapperService::class.java), connection, Context.BIND_AUTO_CREATE)
            }

    fun extractNotification(intent: Intent?) =
            intent?.extras?.getParcelable<Notification>(NOTIFICATION_INTENT_KEY)


    private fun createServiceConnection(emitter: ObservableEmitter<PacketProvider>): ServiceConnection =
            object : ServiceConnection {
                override fun onServiceConnected(name: ComponentName, binder: IBinder) = emitter.onNext((binder as LocalBinder).service)
                override fun onServiceDisconnected(name: ComponentName?) = Unit
            }

    private fun startServiceWithNotification(applicationContext: Context, notification: Notification) {
        val intent = Intent(applicationContext, PacketProviderWrapperService::class.java).putExtra(NOTIFICATION_INTENT_KEY, notification)
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) applicationContext.startForegroundService(intent)
        else applicationContext.startService(intent)
    }
}