package com.estimote.scanning_plugin.dagger

import android.bluetooth.BluetoothAdapter
import com.estimote.internal_plugins_api.scanning.BluetoothBackgroundTriggerConfigurator
import com.estimote.scanning_plugin.api.EstimoteBluetoothBackgroundTriggerConfigurator
import com.estimote.scanning_plugin.packet_provider.scanner.filter_transformers.*
import com.estimote.scanning_plugin.packet_provider.scanner.settings_transformers.ScanSettingsTransformerProvider
import dagger.Module
import dagger.Provides

@Module
internal class BluetoothTriggerModule {

    @Provides
    @EstimoteScanningSdkScope
    fun providesBluetoothTriggerConfigurator(
            adapter: BluetoothAdapter?,
            scanSettingsTransformerProvider: ScanSettingsTransformerProvider): BluetoothBackgroundTriggerConfigurator =
            EstimoteBluetoothBackgroundTriggerConfigurator(
                    adapter,
                    scanSettingsTransformerProvider.getTransformer(),
                    DefaultScanFiltersTransformer(
                            ToIBeaconFilterTransformer(HardwareFilterBuilderFactory()),
                            ToEddystoneFilterTransformer(HardwareFilterBuilderFactory(), ServicesUuidConfig()),
                            ToEstimoteTelemetryFilterTransformer(HardwareFilterBuilderFactory(), ServicesUuidConfig()),
                            ToEstimoteLocationFilterTransformer(HardwareFilterBuilderFactory(), ServicesUuidConfig()),
                            ToEstimoteMeshFilterTransformer(HardwareFilterBuilderFactory(), ServicesUuidConfig()),
                            ToMirrorFilterTransformer(HardwareFilterBuilderFactory(), ServicesUuidConfig()),
                            ToUwbFilterTransformer(HardwareFilterBuilderFactory(), ServicesUuidConfig()),
                            ToNearableFilterTransformer(HardwareFilterBuilderFactory(), ServicesUuidConfig()),
                            ToConfigurableDeviceFilterTransformer(HardwareFilterBuilderFactory(), ServicesUuidConfig()),
                            ToEstimoteSecureFilterTransformers(HardwareFilterBuilderFactory(), ServicesUuidConfig()),
                            ToEstimoteRescueFilterTransformer(HardwareFilterBuilderFactory(), ServicesUuidConfig())))
}