package com.estimote.management_sdk.configuration_manager.internals

import com.estimote.management_sdk.configuration_manager.SyncableDevice
import io.reactivex.Completable
import io.reactivex.android.schedulers.AndroidSchedulers


internal class ToVisitableForwardingSyncableDevice(
        private val visitableDevice: SyncableDeviceVisitorUseCase.VisitableDevice,
        private val syncCommandsToTheDeviceUseCase: SyncableDeviceVisitorUseCase<Completable>,
        private val syncMeshMessageToDeviceUseCase: SyncableDeviceVisitorUseCase<Completable>) : SyncableDevice {

    override fun syncMeshMessageBuffer(callback: SyncableDevice.SyncableDeviceCallback) =
            runUseCase(syncMeshMessageToDeviceUseCase, callback)

    override fun syncDeviceCommands(callback: SyncableDevice.SyncableDeviceCallback) =
            runUseCase(syncCommandsToTheDeviceUseCase, callback)


    override fun syncWithCloud(callback: SyncableDevice.SyncableDeviceCallback) {
        rxRunUseCase(syncCommandsToTheDeviceUseCase).andThen(rxRunUseCase(syncMeshMessageToDeviceUseCase)).subscribe({ callback.onCompleted() }, { callback.onError(it) })
    }

    private fun runUseCase(useCase: SyncableDeviceVisitorUseCase<Completable>, callback: SyncableDevice.SyncableDeviceCallback) {
        visitableDevice.accept(useCase).observeOn(AndroidSchedulers.mainThread()).subscribe({ callback.onCompleted() }, { callback.onError(it) })
    }

    private fun rxRunUseCase(useCase: SyncableDeviceVisitorUseCase<Completable>)
            = Completable.create { emitter -> runUseCase(useCase, object : SyncableDevice.SyncableDeviceCallback {
            override fun onCompleted() = emitter.onComplete()
            override fun onError(cause: Throwable) = emitter.onComplete()
        })
    }

}