package com.estimote.management_sdk.configuration_manager.internals


internal abstract class SyncableDeviceVisitorUseCase<out T> {
    fun visit(device: VisitableBeacon): T = execute(device.configurableDevice.appVersion, { onFirmwareVersionSupported(device) })
    fun visit(device: VisitableMirror): T  = execute(device.configurableDevice.appVersion, { onFirmwareVersionSupported(device) })
    fun visit(device: VisitableSticker): T = execute(device.configurableDevice.appVersion, { onFirmwareVersionSupported(device) })

    abstract fun useCaseMinFirmwareVersion(): String
    abstract fun onFirmwareVersionNotSupported(): T
    open fun onFirmwareVersionSupported(device: VisitableBeacon): T = throw UnsupportedOperationException("visit operation is not supported for SyncableBeacon device")
    open fun onFirmwareVersionSupported(device: VisitableMirror): T = throw UnsupportedOperationException("visit operation is not supported for SyncableBeacon device")
    open fun onFirmwareVersionSupported(device: VisitableSticker): T = throw UnsupportedOperationException("visit operation is not supported for SyncableBeacon device")

    interface VisitableDevice {
        fun <T> accept(useCaseVisitor: SyncableDeviceVisitorUseCase<out T>): T
    }

    private fun SyncableDeviceVisitorUseCase<T>.execute(deviceFirmwareVersion: String, useCase: () -> T): T =
            if (supportsFirmwareVersion(deviceFirmwareVersion)) useCase()
            else onFirmwareVersionNotSupported()

    private fun supportsFirmwareVersion(deviceFirmwareVersion: String): Boolean {
        try {
            return Version.compareStrings(deviceFirmwareVersion, useCaseMinFirmwareVersion()) >= 0
        }catch (e: Exception) {
            return false
        }
    }
}

