package com.estimote.management_sdk.configuration_manager.dagger

import com.estimote.internal_plugins_api.scanning.ScanningStack
import com.estimote.management_sdk.configuration_manager.cloud.LegacySettingsManager
import com.estimote.management_sdk.configuration_manager.cloud.ManagementCloud
import com.estimote.management_sdk.configuration_manager.internals.EstimoteConnectivityAdapter
import dagger.Module
import dagger.Provides
import javax.inject.Singleton

@Module
internal class ManagementSDKModule(private val managementCloud: ManagementCloud,
                                   private val legacySettingsManager: LegacySettingsManager,
                                   private val scanningStack: ScanningStack) {

    @Provides @Singleton fun provideCloudManager(): ManagementCloud = managementCloud

    @Provides @Singleton fun provideLegacySettingsManager(): LegacySettingsManager = legacySettingsManager

    @Provides @Singleton fun provideLegacyScanningStack(): ScanningStack = scanningStack

    @Provides @Singleton fun provideEstimoteConnectivityAdapter() = EstimoteConnectivityAdapter()


}