package com.estimote.management_sdk.configuration_manager

import com.estimote.internal_plugins_api.scanning.ScanningStack
import com.estimote.management_sdk.configuration_manager.cloud.LegacySettingsManager
import com.estimote.management_sdk.configuration_manager.cloud.ManagementCloud
import com.estimote.management_sdk.configuration_manager.internals.EstimoteConnectivityAdapter
import com.estimote.management_sdk.configuration_manager.internals.ToVisitableForwardingSyncableDevice
import com.estimote.management_sdk.configuration_manager.internals.VisitableBeacon
import com.estimote.management_sdk.configuration_manager.use_case.SyncBeaconMeshMessageUseCase
import com.estimote.management_sdk.configuration_manager.use_case.SyncCommandsToTheDeviceUseCase
import javax.inject.Inject


/**
 * This is the main API class for management SDK.
 */

class ConfigurationManager {
    @Inject lateinit var legacySettingsManager: LegacySettingsManager
    @Inject lateinit var managementCloud: ManagementCloud
    @Inject lateinit var scanningStack: ScanningStack
    @Inject lateinit var packetAdapter: EstimoteConnectivityAdapter

    init { ManagementSDK.managementSdkComponent?.inject(this) }


    interface SyncableDevicesScanCallback {
        fun onSyncableDevicesFound(syncableDevices: Collection<SyncableDevice>)
        fun onSyncableDevicesScanError(cause: Throwable)
    }

    fun scanForSyncableDevices(callback: SyncableDevicesScanCallback) {
        scanningStack.discoveryConfigurableDevices()
                .map { configurableDevices -> configurableDevices.map { ToVisitableForwardingSyncableDevice(VisitableBeacon(packetAdapter.toConfigurableDevice(it)), SyncCommandsToTheDeviceUseCase(managementCloud, legacySettingsManager), SyncBeaconMeshMessageUseCase(managementCloud, legacySettingsManager)) } }
                .subscribe({ callback.onSyncableDevicesFound(it) }, {callback.onSyncableDevicesScanError(it)})
    }
}