package com.estimote.managemet_sdk.configuration_manager.cloud

import com.google.gson.annotations.SerializedName


data class MeshSettingsVersionUpdate(val identifier: String, val settings: MeshSettings)

data class MeshSettings(val advertisers: MeshAdvertiser)

data class MeshAdvertiser(val mesh: Array<MeshData>)

data class MeshData(val index: Int = 1, @SerializedName("settings_version") val settingsVersion: Long)


class MeshSettingsVersionUpdateFactory {
    fun create(deviceId: String, settingsVersion: Long): MeshSettingsVersionUpdate {
        return MeshSettingsVersionUpdate(deviceId, MeshSettings(MeshAdvertiser(arrayOf(MeshData(settingsVersion = settingsVersion)))))
    }
}