package com.estimote.managemet_sdk.configuration_manager.cloud

import android.content.Context
import com.estimote.cloud_plugin.api.SdkInfo
import com.estimote.cloud_plugin.api.createRestApi
import com.estimote.cloud_plugin.common.info.CommonDeviceInfoProvider

/**
 * @author Estimote Inc. (contact@estimote.com)
 */
class ManagementCloudFactory {


    fun create(applicationContext: Context,
               appId: String,
               appToken: String,
               sdkInfo: SdkInfo) : ManagementCloud =
            EstimoteManagementCloud(createRestApi(
                    ManagementCloudRestApi::class.java,
                    "http://cloud.estimote.com",
                    appId,
                    appToken,
                    sdkInfo,
                    CommonDeviceInfoProvider().provideGeneralInfo(applicationContext)))

}