package com.estimote.managemet_sdk.configuration_manager.cloud

import com.estimote.managemet_sdk.configuration_manager.cloud.*
import io.reactivex.Completable
import io.reactivex.Observable

/**
 * @author Estimote Inc. (contact@estimote.com)
 */

interface ManagementCloud {
    fun getMeshMessageForDevice(deviceId: CloudDeviceId): Observable<CloudMeshMessage>
    fun updateSettingsVersion(deviceId: String, cloudMessage: CloudMeshMessage): Observable<CloudMeshMessage>
    fun putMeshMessageBuffer(cloudMessage: CloudMeshMessage): Completable

    fun getCommandsForDevice(deviceId: CloudDeviceId): Observable<CloudCommands>
    fun deleteCommands(deviceId: CloudDeviceId): Completable
    fun confirmCommands(deviceId: CloudDeviceId, cloudCommands: CloudCommands): Completable

    fun getMeshesList(): Observable<List<CloudMeshConfig>>
    fun getMeshSettingsVersion(meshId: Long): Observable<CloudMeshSettingsVersion>

    fun confirmMeshSettings(confirmationRequests: List<MeshSettingsConfirmationRequest>): Observable<MeshSettingsConfirmationResponse>

    fun sendMeshScanReport(meshScanReport: MeshScanReport): Observable<MeshScanReportResponse>

    enum class RequestStatus { COMPLETE }
}