package com.estimote.managemet_sdk.configuration_manager

import android.content.Context
import com.estimote.cloud_plugin.api.SdkInfo
import com.estimote.cloud_plugin.api.createRestApi
import com.estimote.cloud_plugin.common.info.CommonDeviceInfoProvider
import com.estimote.internal_plugins_api.scanning.ScanningStack
import com.estimote.managemet_sdk.configuration_manager.cloud.EstimoteManagementCloud
import com.estimote.managemet_sdk.configuration_manager.cloud.LegacySettingsManager
import com.estimote.managemet_sdk.configuration_manager.cloud.ManagementCloudRestApi
import com.estimote.managemet_sdk.configuration_manager.dagger.DaggerManagementSDKComponent
import com.estimote.managemet_sdk.configuration_manager.dagger.ManagementSDKComponent
import com.estimote.managemet_sdk.configuration_manager.dagger.ManagementSDKModule

object ManagementSDK {
    @JvmStatic
    internal var managementSdkComponent: ManagementSDKComponent? = null

    @JvmStatic
    fun initialize(
            applicationContext: Context,
            appId: String,
            appToken: String,
            sdkInfo: SdkInfo,
            legacySettingsManager: LegacySettingsManager,
            scanningStack: ScanningStack) {

        managementSdkComponent = DaggerManagementSDKComponent.builder()
                .managementSDKModule(ManagementSDKModule(EstimoteManagementCloud(createRestApi(
                        ManagementCloudRestApi::class.java,
                        "http://cloud.estimote.com",
                        appId,
                        appToken,
                        sdkInfo,
                        CommonDeviceInfoProvider().provideGeneralInfo(applicationContext))), legacySettingsManager, scanningStack))
                .build()
    }


}