/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.managemet_sdk.configuration_manager.use_case;

import com.estimote.managemet_sdk.configuration_manager.cloud.CloudCommands;
import com.estimote.managemet_sdk.configuration_manager.cloud.CloudDeviceId;
import com.estimote.managemet_sdk.configuration_manager.cloud.LegacySettingsManager;
import com.estimote.managemet_sdk.configuration_manager.cloud.ManagementCloud;
import com.estimote.managemet_sdk.configuration_manager.internals.SyncableDeviceVisitorUseCase;
import com.estimote.managemet_sdk.configuration_manager.internals.VisitableBeacon;
import com.estimote.managemet_sdk.configuration_manager.use_case.SyncCommandsToTheDeviceUseCase;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.functions.Function;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\n \t*\u0004\u0018\u00010\u00020\u0002H\u0016J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\u0011\u001a\u00020\u0002*\b\u0012\u0004\u0012\u00020\u000e0\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010*\b\u0012\u0004\u0012\u00020\u000e0\u0010H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/estimote/managemet_sdk/configuration_manager/use_case/SyncCommandsToTheDeviceUseCase;", "Lcom/estimote/managemet_sdk/configuration_manager/internals/SyncableDeviceVisitorUseCase;", "Lio/reactivex/Completable;", "managementCloud", "Lcom/estimote/managemet_sdk/configuration_manager/cloud/ManagementCloud;", "legacySettingsManager", "Lcom/estimote/managemet_sdk/configuration_manager/cloud/LegacySettingsManager;", "(Lcom/estimote/managemet_sdk/configuration_manager/cloud/ManagementCloud;Lcom/estimote/managemet_sdk/configuration_manager/cloud/LegacySettingsManager;)V", "onFirmwareVersionNotSupported", "kotlin.jvm.PlatformType", "onFirmwareVersionSupported", "device", "Lcom/estimote/managemet_sdk/configuration_manager/internals/VisitableBeacon;", "useCaseMinFirmwareVersion", "", "whenCommandsAreObtained", "Lio/reactivex/Observable;", "andConfirmThemForThisDevice", "thenSaveEachOfThemInToDevice", "management-sdk_release"})
public final class SyncCommandsToTheDeviceUseCase
extends SyncableDeviceVisitorUseCase<Completable> {
    private final ManagementCloud managementCloud;
    private final LegacySettingsManager legacySettingsManager;

    @Override
    @NotNull
    public String useCaseMinFirmwareVersion() {
        return "4.13.0";
    }

    @Override
    public Completable onFirmwareVersionNotSupported() {
        return Completable.complete();
    }

    @Override
    @NotNull
    public Completable onFirmwareVersionSupported(@NotNull VisitableBeacon device) {
        Intrinsics.checkParameterIsNotNull((Object)device, (String)"device");
        return this.andConfirmThemForThisDevice(this.thenSaveEachOfThemInToDevice(this.whenCommandsAreObtained(device)), device);
    }

    private final Observable<String> whenCommandsAreObtained(VisitableBeacon device) {
        String string = device.getConfigurableDevice().deviceId.toHexString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"device.configurableDevice.deviceId.toHexString()");
        Observable observable = this.managementCloud.getCommandsForDevice(new CloudDeviceId(string)).map((Function)whenCommandsAreObtained.1.INSTANCE).flatMapIterable((Function)whenCommandsAreObtained.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"managementCloud.getComma\u2026ds }.flatMapIterable {it}");
        return observable;
    }

    private final Observable<String> thenSaveEachOfThemInToDevice(@NotNull Observable<String> $receiver) {
        Observable observable = $receiver.flatMapSingle(new Function<T, SingleSource<? extends R>>(this){
            final /* synthetic */ SyncCommandsToTheDeviceUseCase this$0;

            public final Single<String> apply(@NotNull String command) {
                Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
                return SyncCommandsToTheDeviceUseCase.access$getLegacySettingsManager$p(this.this$0).saveCommand(command).toSingle((Callable)new Callable<String>(command){
                    final /* synthetic */ String $command;

                    @NotNull
                    public final String call() {
                        return this.$command;
                    }
                    {
                        this.$command = string;
                    }
                });
            }
            {
                this.this$0 = syncCommandsToTheDeviceUseCase;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"this.flatMapSingle { com\u2026d).toSingle { command } }");
        return observable;
    }

    private final Completable andConfirmThemForThisDevice(@NotNull Observable<String> $receiver, VisitableBeacon device) {
        Completable completable = $receiver.flatMapCompletable((Function)new Function<String, CompletableSource>(this, device){
            final /* synthetic */ SyncCommandsToTheDeviceUseCase this$0;
            final /* synthetic */ VisitableBeacon $device;

            @NotNull
            public final Completable apply(@NotNull String command) {
                Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
                ManagementCloud managementCloud = SyncCommandsToTheDeviceUseCase.access$getManagementCloud$p(this.this$0);
                String string = this.$device.getConfigurableDevice().deviceId.toHexString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"device.configurableDevice.deviceId.toHexString()");
                return managementCloud.confirmCommands(new CloudDeviceId(string), new CloudCommands(CollectionsKt.listOf((Object)command)));
            }
            {
                this.this$0 = syncCommandsToTheDeviceUseCase;
                this.$device = visitableBeacon;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"this.flatMapCompletable \u2026mands(listOf(command))) }");
        return completable;
    }

    public SyncCommandsToTheDeviceUseCase(@NotNull ManagementCloud managementCloud, @NotNull LegacySettingsManager legacySettingsManager) {
        Intrinsics.checkParameterIsNotNull((Object)managementCloud, (String)"managementCloud");
        Intrinsics.checkParameterIsNotNull((Object)legacySettingsManager, (String)"legacySettingsManager");
        this.managementCloud = managementCloud;
        this.legacySettingsManager = legacySettingsManager;
    }

    @NotNull
    public static final /* synthetic */ LegacySettingsManager access$getLegacySettingsManager$p(SyncCommandsToTheDeviceUseCase $this) {
        return $this.legacySettingsManager;
    }

    @NotNull
    public static final /* synthetic */ ManagementCloud access$getManagementCloud$p(SyncCommandsToTheDeviceUseCase $this) {
        return $this.managementCloud;
    }
}

