package com.estimote.managemet_sdk.configuration_manager.internals

import com.estimote.coresdk.recognition.packets.ConfigurableDevice
import com.estimote.coresdk.recognition.utils.DeviceId
import com.estimote.coresdk.recognition.utils.MacAddress
import com.estimote.internal_plugins_api.scanning.DeviceType
import com.estimote.internal_plugins_api.scanning.EstimoteConnectivity

/**
 * @author Estimote Inc. (contact@estimote.com)
 */
class EstimoteConnectivityAdapter {

    // Value of RSSI measured at 1m from device. Not all packets support this,
    // so I need to hard code it.
    private val DEFAULT_MEASURED_POWER_VALUE = -60

    /**
     * Estimote Connectivity -> Configurable Device
     */
    fun toConfigurableDevice(estimoteConnectivity: EstimoteConnectivity): ConfigurableDevice {
        with(estimoteConnectivity) {
            return ConfigurableDevice(
                    adaptDeviceType(),
                    adaptDeviceid(),
                    adaptMacAddress(),
                    appVersion,
                    bootloaderVersion,
                    shakeToConnect,
                    nearToConnect,
                    rssi,
                    DEFAULT_MEASURED_POWER_VALUE,
                    timestamp
            )
        }
    }

    private fun EstimoteConnectivity.adaptDeviceType() =
            when (this.deviceType) {
                DeviceType.LOCATION_BEACON -> com.estimote.coresdk.recognition.packets.DeviceType.LOCATION_BEACON
                DeviceType.PROXIMITY_BEACON -> com.estimote.coresdk.recognition.packets.DeviceType.PROXIMITY_BEACON
                DeviceType.NEARABLE -> com.estimote.coresdk.recognition.packets.DeviceType.NEARABLE
                DeviceType.MIRROR -> com.estimote.coresdk.recognition.packets.DeviceType.MIRROR
                DeviceType.LTE_BEACON -> com.estimote.coresdk.recognition.packets.DeviceType.LTE_BEACON
                DeviceType.UNKNOWN -> com.estimote.coresdk.recognition.packets.DeviceType.LOCATION_BEACON
            }

    private fun EstimoteConnectivity.adaptDeviceid() = DeviceId.fromString(this.deviceId)

    private fun EstimoteConnectivity.adaptMacAddress() = MacAddress.fromString(macAddress.address)
}