package com.estimote.managemet_sdk.configuration_manager.cloud

/**
 * @author Estimote Inc. (contact@estimote.com)
 */
import com.estimote.managemet_sdk.configuration_manager.cloud.ManagementCloud.RequestStatus
import io.reactivex.Completable
import io.reactivex.Observable
import retrofit2.http.*

internal interface ManagementCloudRestApi {
    @GET("v3/devices/{id}")
    fun getDeviceMeshId(@Path("id") id: String): Observable<MeshId>

    @GET("v3/mesh/{mesh_id}/message_buffer")
    fun getMeshMessage(@Path("mesh_id") id: Long): Observable<CloudMeshMessageBody>

    @POST("/v3/devices/{id}")
    fun updateSettingsVersion(@Path("id") deviceId: String, @Body data: MeshSettingsVersionUpdate): Observable<RequestStatus>

    @PUT("v3/mesh/{mesh_id}/message_buffer")
    fun putMeshMessageBuffer(@Path("mesh_id") id: Long, @Body bufferConfirmationMessage: BufferConfirmationMessage): Completable

    @GET("v3/devices/{id}/commands")
    fun getCommandsForDevice(@Path("id") deviceId: String): Observable<CloudCommands>

    @DELETE("v3/devices/{id}/commands")
    fun deleteCommands(@Path("id") deviceId: String): Completable

    @POST("v3/devices/{id}/commands/confirm")
    fun confirmCommands(@Path("id") deviceId: String, @Body cloudCommands: CloudCommands): Completable

    @GET("v2/mesh")
    fun getMeshesList(): Observable<CloudMeshConfigs>

    @GET("v3/mesh/{mesh_id}/message_buffer")
    fun getMeshSettingsVersion(@Path("mesh_id") meshId: Long): Observable<CloudMeshSettingsVersion>

    @POST("v2/mesh/confirm")
    fun confirmMeshSettings(@Body confirmationRequests: List<MeshSettingsConfirmationRequest>): Observable<MeshSettingsConfirmationResponse>

    @POST("v3/asset_tracking/reports")
    fun sendMeshScanReport(@Body meshScanReport: MeshScanReport): Observable<MeshScanReportResponse>
}